/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.maven.plugin;

import io.ultreia.java4all.validation.impl.definition.ProjectValidatorFileDefinition;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorFileDefinitionHelper;
import io.ultreia.java4all.validation.maven.plugin.AbstractValidationMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-files-json", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateValidatorsFileMojo
extends AbstractValidationMojo {
    @Parameter(defaultValue="${basedir}/src/main/resources", required=true)
    protected File src;
    @Parameter(defaultValue="${basedir}/src/main/resources", required=true)
    protected File target;

    public void execute() throws MojoExecutionException {
        ProjectValidatorFileDefinitionHelper helper = new ProjectValidatorFileDefinitionHelper();
        try {
            Path path = this.src.toPath();
            ProjectValidatorFileDefinition model = helper.build(path);
            this.getLog().info((CharSequence)String.format("%d file(s) detected.", model.getFiles().size()));
            Path location = helper.write(model, this.target.toPath());
            this.getLog().info((CharSequence)String.format("files.json generated at %s", location));
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }
}

