/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.adapters.ClassAdapter;
import io.ultreia.java4all.validation.impl.ProjectValidatorMapping;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorFileDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.NuitonScopeValidator;

public class ProjectValidatorMappingHelper {
    public static final String LOCATION = "META-INF/validation/mapping.json";
    private static final Logger log = LogManager.getLogger(ProjectValidatorMappingHelper.class);

    static Gson creatGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Class.class, (Object)new ClassAdapter()).create();
    }

    public ProjectValidatorMapping readAll() throws IOException {
        Enumeration<URL> resource = Objects.requireNonNull(ProjectValidatorFileDefinition.class.getClassLoader().getResources(LOCATION));
        Gson gson = ProjectValidatorMappingHelper.creatGson();
        TreeMap mapping = new TreeMap();
        while (resource.hasMoreElements()) {
            URL url = resource.nextElement();
            mapping.putAll(this.readFile(gson, url));
        }
        return new ProjectValidatorMapping(mapping);
    }

    public ProjectValidatorMapping read(URL url) throws IOException {
        Gson gson = ProjectValidatorMappingHelper.creatGson();
        Map<String, Class<? extends NuitonScopeValidator<?>>> filesByEntry = this.readFile(gson, url);
        return new ProjectValidatorMapping(filesByEntry);
    }

    public ProjectValidatorMapping read(Path path) throws IOException {
        return this.read(this.toLocation(path).toUri().toURL());
    }

    public Path write(ProjectValidatorMapping model, Path target) throws IOException {
        Gson gson = ProjectValidatorMappingHelper.creatGson();
        String content = gson.toJson(model.getMapping());
        Path location = this.toLocation(target);
        if (Files.notExists(location.getParent(), new LinkOption[0])) {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        Files.writeString(location, (CharSequence)content, new OpenOption[0]);
        return location;
    }

    public Path write(Map<String, String> model, Path target) throws IOException {
        Gson gson = ProjectValidatorMappingHelper.creatGson();
        String content = gson.toJson(model);
        Path location = this.toLocation(target);
        if (Files.notExists(location.getParent(), new LinkOption[0])) {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        Files.writeString(location, (CharSequence)content, new OpenOption[0]);
        return location;
    }

    public Path toLocation(Path target) {
        return target.resolve(LOCATION);
    }

    private Map<String, Class<? extends NuitonScopeValidator<?>>> readFile(Gson gson, URL url) throws IOException {
        log.info("Loading file: {}", (Object)url);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Class<? extends NuitonScopeValidator<?>>>>(){}.getType());
            return map;
        }
    }
}

