/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.adapters.ClassAdapter;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorFileDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectValidatorFileDefinitionHelper {
    public static final String LOCATION = "META-INF/validation/files.json";
    private static final Logger log = LogManager.getLogger(ProjectValidatorFileDefinitionHelper.class);

    static Gson creatGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Class.class, (Object)new ClassAdapter()).disableHtmlEscaping().create();
    }

    public ProjectValidatorFileDefinition build(Path rootPath) throws IOException {
        List<String> pathsByEntry = this.detectFiles(rootPath);
        return new ProjectValidatorFileDefinition(pathsByEntry);
    }

    public ProjectValidatorFileDefinition readAll() throws IOException {
        Enumeration<URL> resource = Objects.requireNonNull(ProjectValidatorFileDefinition.class.getClassLoader().getResources(LOCATION));
        Gson gson = ProjectValidatorFileDefinitionHelper.creatGson();
        LinkedList<String> filesByEntry = new LinkedList<String>();
        while (resource.hasMoreElements()) {
            URL url = resource.nextElement();
            filesByEntry.addAll(this.readFile(gson, url));
        }
        filesByEntry.sort(String::compareTo);
        return new ProjectValidatorFileDefinition(filesByEntry);
    }

    public ProjectValidatorFileDefinition read(URL url) throws IOException {
        Gson gson = ProjectValidatorFileDefinitionHelper.creatGson();
        List<String> filesByEntry = this.readFile(gson, url);
        filesByEntry.sort(String::compareTo);
        return new ProjectValidatorFileDefinition(filesByEntry);
    }

    public ProjectValidatorFileDefinition read(Path path) throws IOException {
        return this.read(this.toLocation(path).toUri().toURL());
    }

    public Path write(ProjectValidatorFileDefinition model, Path target) throws IOException {
        Gson gson = ProjectValidatorFileDefinitionHelper.creatGson();
        String content = gson.toJson(model.getFiles());
        Path location = this.toLocation(target);
        if (Files.notExists(location.getParent(), new LinkOption[0])) {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        Files.writeString(location, (CharSequence)content, new OpenOption[0]);
        return location;
    }

    public Path toLocation(Path target) {
        return target.resolve(LOCATION);
    }

    private List<String> detectFiles(final Path rootPath) throws IOException {
        log.info("Scan rootPath {}", (Object)rootPath);
        final LinkedList<String> result = new LinkedList<String>();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toFile().getName().endsWith("-validation.json")) {
                    log.trace("Scan file {}", (Object)file);
                    String path = "/" + rootPath.relativize(file);
                    result.add(path);
                    log.debug("Detect validation file: {}", (Object)path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        result.sort(String::compareTo);
        log.info("{} file(s) detected.", (Object)result.size());
        return result;
    }

    private List<String> readFile(Gson gson, URL url) throws IOException {
        log.info("Loading file: {}", (Object)url);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            List list = (List)gson.fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType());
            return list;
        }
    }
}

