/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.io;

import io.ultreia.java4all.lang.Objects2;
import io.ultreia.java4all.validation.impl.definition.FileValidatorDefinition;
import io.ultreia.java4all.validation.impl.definition.FileValidatorEntryDefinition;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorDefinition;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorFileDefinition;
import io.ultreia.java4all.validation.impl.io.FileValidatorModelBuilder;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorFileDefinitionHelper;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectValidatorDefinitionBuilder {
    private static final Logger log = LogManager.getLogger(ProjectValidatorDefinitionBuilder.class);
    private final FileValidatorModelBuilder fileValidatorModelBuilder;
    private final ClassLoader classLoader;

    public ProjectValidatorDefinitionBuilder() {
        this(null);
    }

    public ProjectValidatorDefinitionBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.fileValidatorModelBuilder = new FileValidatorModelBuilder();
    }

    static FileValidatorEntryDefinition toEntryDefinition(String location) {
        Path path = Path.of(Objects.requireNonNull(location), new String[0]);
        Path packagePath = path.getParent();
        String packageName = packagePath.toString().substring(1).replaceAll("/", ".");
        String name = path.toFile().getName();
        int index = name.indexOf(45);
        String classSimpleName = name.substring(0, index);
        String className = packageName + "." + classSimpleName;
        Class classType = Objects2.forName((String)className);
        String contextAndScope = name.substring(index + 1, name.lastIndexOf(45));
        index = contextAndScope.lastIndexOf(45);
        String scope = contextAndScope.substring(index + 1);
        String context = index == -1 ? null : contextAndScope.substring(0, index);
        return new FileValidatorEntryDefinition(classType, context, scope);
    }

    public ProjectValidatorDefinition buildAll() throws IOException {
        ProjectValidatorFileDefinition filesModel = new ProjectValidatorFileDefinitionHelper().readAll();
        return this.createProjectValidatorModel(filesModel);
    }

    public ProjectValidatorDefinition build(URL location) throws IOException {
        ProjectValidatorFileDefinition filesModel = new ProjectValidatorFileDefinitionHelper().read(location);
        return this.createProjectValidatorModel(filesModel);
    }

    private ProjectValidatorDefinition createProjectValidatorModel(ProjectValidatorFileDefinition filesModel) {
        TreeMap<FileValidatorEntryDefinition, FileValidatorDefinition> filesByEntry = new TreeMap<FileValidatorEntryDefinition, FileValidatorDefinition>();
        for (String file : filesModel.getFiles()) {
            FileValidatorEntryDefinition key = ProjectValidatorDefinitionBuilder.toEntryDefinition(file);
            URL resource = Objects.requireNonNull(this.classLoader.getResource(file.substring(1)));
            log.info("Loading {} \u2192 {}", (Object)resource, (Object)key);
            FileValidatorDefinition fileValidatorDefinition = this.fileValidatorModelBuilder.build(resource, key.getBeanType(), key.getScope(), key.getContext());
            filesByEntry.put(key, fileValidatorDefinition);
        }
        return new ProjectValidatorDefinition(filesByEntry);
    }
}

