/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.io;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.ultreia.java4all.validation.impl.definition.FieldValidatorDefinition;
import io.ultreia.java4all.validation.impl.definition.FileValidatorDefinition;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorFileDefinitionHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileValidatorModelBuilder {
    private static final Logger log = LogManager.getLogger(FileValidatorModelBuilder.class);
    private final Gson gson = ProjectValidatorFileDefinitionHelper.creatGson();

    public FileValidatorDefinition build(URL file, Class<?> type, String scope, String context) {
        FileValidatorDefinition fileValidatorDefinition;
        log.info("Building fileValidatorModel for type {} - scope {} - context {}", (Object)type.getName(), (Object)scope, (Object)context);
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.openStream()));
        try {
            Map fields = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, List<FieldValidatorDefinition>>>(){}.getType());
            TreeMap<String, List<FieldValidatorDefinition>> finalFields = new TreeMap<String, List<FieldValidatorDefinition>>();
            fields.forEach((k, v) -> {
                ArrayList finalFieldValidatorDefinitions = new ArrayList();
                finalFields.put((String)k, finalFieldValidatorDefinitions);
                v.forEach(f -> {
                    FieldValidatorDefinition newField = new FieldValidatorDefinition((String)k, f.getComment(), f.getValidator(), f.getParameters(), f.getMessage());
                    finalFieldValidatorDefinitions.add(newField);
                });
            });
            fileValidatorDefinition = new FileValidatorDefinition(type, scope, context, finalFields);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load file " + file, e);
            }
        }
        reader.close();
        return fileValidatorDefinition;
    }
}

