/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.field;

import io.ultreia.java4all.validation.impl.ValidationMessagesCollector;
import io.ultreia.java4all.validation.impl.field.FieldValidator;
import io.ultreia.java4all.validation.impl.field.FieldValidatorSupport;
import io.ultreia.java4all.validation.impl.field.MessageBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.NuitonValidationContext;

public abstract class SkipableFieldValidatorSupport<O, F>
extends FieldValidatorSupport<O, F> {
    private static final Logger log = LogManager.getLogger(SkipableFieldValidatorSupport.class);
    private final BiFunction<O, NuitonValidationContext, Boolean> skipFunction;

    public SkipableFieldValidatorSupport(String fieldName, Function<O, F> fieldFunction) {
        this(fieldName, fieldFunction, null, null, null);
    }

    public SkipableFieldValidatorSupport(String fieldName, Function<O, F> fieldFunction, BiFunction<O, NuitonValidationContext, Boolean> skipFunction) {
        this(fieldName, fieldFunction, null, null, skipFunction);
    }

    public SkipableFieldValidatorSupport(String fieldName, Function<O, F> fieldFunction, String messageKey, MessageBuilder<O, ? super NuitonValidationContext, ? super FieldValidator<O, ?>> messageBuilder, BiFunction<O, NuitonValidationContext, Boolean> skipFunction) {
        super(fieldName, fieldFunction, messageKey, messageBuilder);
        this.skipFunction = skipFunction;
    }

    protected abstract void validateWhenNotSkip(O var1, NuitonValidationContext var2, ValidationMessagesCollector var3);

    @Override
    public void validate(O object, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        boolean mustSkip = this.evaluateSkipParameter(object, validationContext);
        if (mustSkip) {
            if (log.isDebugEnabled()) {
                log.debug("Skip the validation from " + this + ", due to skip parameter evaluated to true");
            }
            return;
        }
        this.validateWhenNotSkip(object, validationContext, messagesCollector);
    }

    protected boolean evaluateSkipParameter(O object, NuitonValidationContext validationContext) {
        return this.skipFunction.apply(object, validationContext);
    }

    protected BiFunction<O, NuitonValidationContext, Boolean> skipFunction() {
        return this.skipFunction;
    }
}

