/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.field;

import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.validation.impl.field.FieldValidator;
import io.ultreia.java4all.validation.impl.field.MessageBuilder;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.nuiton.validator.NuitonValidationContext;

public abstract class FieldValidatorSupport<O, F>
implements FieldValidator<O, F> {
    private final String fieldName;
    private final Function<O, F> fieldFunction;
    private final String messageKey;
    private final MessageBuilder<O, ? super NuitonValidationContext, ? super FieldValidator<O, ?>> messageBuilder;

    public FieldValidatorSupport(String fieldName, Function<O, F> fieldFunction, String messageKey, MessageBuilder<O, ? super NuitonValidationContext, ? super FieldValidator<O, ?>> messageBuilder) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.fieldFunction = fieldFunction;
        this.messageKey = messageKey;
        this.messageBuilder = messageBuilder;
    }

    public FieldValidatorSupport(String fieldName, Function<O, F> fieldFunction) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.fieldFunction = fieldFunction;
        this.messageKey = null;
        this.messageBuilder = null;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public F getField(O object) {
        return Objects.requireNonNull(this.fieldFunction()).apply(object);
    }

    @Override
    public String getMessage(O object, NuitonValidationContext validationContext) {
        if (this.messageKey == null) {
            return null;
        }
        if (this.messageBuilder == null) {
            return I18n.l((Locale)validationContext.getLocale(), (String)this.messageKey, (Object[])new Object[0]);
        }
        return this.messageBuilder.build(object, (NuitonValidationContext)validationContext, this, this.messageKey);
    }

    protected Function<O, F> fieldFunction() {
        return this.fieldFunction;
    }
}

