/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.field;

import io.ultreia.java4all.validation.impl.field.FieldExpressionValidator;
import io.ultreia.java4all.validation.impl.field.FieldValidator;
import io.ultreia.java4all.validation.impl.field.FieldValidatorFunction;
import io.ultreia.java4all.validation.impl.field.MessageBuilder;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.NuitonValidationContext;

public class FieldExpressionWithParamsValidator<O, F>
extends FieldExpressionValidator<O, F> {
    protected static final Pattern EXTRA_BOOLEAN_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(false|true)");
    protected static final Pattern EXTRA_SHORT_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(-\\d+|\\d+)");
    protected static final Pattern EXTRA_INT_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(-\\d+|\\d+)");
    protected static final Pattern EXTRA_LONG_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(-\\d+|\\d+)");
    protected static final Pattern EXTRA_DOUBLE_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(-\\d+\\.\\d+|\\d+\\.\\d+)");
    protected static final Pattern EXTRA_STRING_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+):(.+)");
    private static final Logger log = LogManager.getLogger(FieldExpressionWithParamsValidator.class);
    private final Map<String, Boolean> booleans;
    private final Map<String, Short> shorts;
    private final Map<String, Integer> ints;
    private final Map<String, Long> longs;
    private final Map<String, Double> doubles;
    private final Map<String, String> strings;

    public FieldExpressionWithParamsValidator(String fieldName, Function<O, F> fieldFunction, String messageKey, MessageBuilder<O, ? super NuitonValidationContext, ? super FieldValidator<O, ?>> messageFunction, BiFunction<O, NuitonValidationContext, Boolean> skipFunction, FieldValidatorFunction<O, ? super NuitonValidationContext, ? super FieldExpressionValidator<O, ?>, Boolean> expressionFunction, Map<String, Object> parameters) {
        super(fieldName, fieldFunction, messageKey, messageFunction, skipFunction, expressionFunction);
        String booleanParams = (String)parameters.get("booleanParams");
        String shortParams = (String)parameters.get("shortParams");
        String intParams = (String)parameters.get("intParams");
        String longParams = (String)parameters.get("longParams");
        String doubleParams = (String)parameters.get("doubleParams");
        String stringParams = (String)parameters.get("stringParams");
        this.booleans = this.initParams(Boolean.class, booleanParams, EXTRA_BOOLEAN_PARAM_ENTRY_PATTERN);
        this.shorts = this.initParams(Short.class, shortParams, EXTRA_SHORT_PARAM_ENTRY_PATTERN);
        this.ints = this.initParams(Integer.class, intParams, EXTRA_INT_PARAM_ENTRY_PATTERN);
        this.longs = this.initParams(Long.class, longParams, EXTRA_LONG_PARAM_ENTRY_PATTERN);
        this.doubles = this.initParams(Double.class, doubleParams, EXTRA_DOUBLE_PARAM_ENTRY_PATTERN);
        this.strings = this.initParams(String.class, stringParams, EXTRA_STRING_PARAM_ENTRY_PATTERN);
    }

    public Map<String, Boolean> getBooleans() {
        return this.booleans;
    }

    public Map<String, Double> getDoubles() {
        return this.doubles;
    }

    public Map<String, Integer> getInts() {
        return this.ints;
    }

    public Map<String, Long> getLongs() {
        return this.longs;
    }

    public Map<String, Short> getShorts() {
        return this.shorts;
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    protected <T> Map<String, T> initParams(Class<T> klass, String extraParams, Pattern pattern) {
        if (extraParams == null || extraParams.isEmpty()) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(extraParams, "|");
        TreeMap<String, T> result = new TreeMap<String, T>();
        while (stk.hasMoreTokens()) {
            String entry = stk.nextToken();
            Matcher matcher = pattern.matcher(entry);
            if (!matcher.matches()) {
                throw new IllegalStateException("could not parse for extra params " + extraParams + " for type " + klass.getName());
            }
            String paramName = matcher.group(1);
            String paramValueStr = matcher.group(2);
            T paramValue = this.convert(klass, paramValueStr);
            if (log.isDebugEnabled()) {
                log.debug("detected extra param : <type:" + klass + ", name:" + paramName + ", value:" + paramValue + ">");
            }
            result.put(paramName, paramValue);
        }
        return result;
    }

    private <T> T convert(Class<T> klass, String paramValueStr) {
        if (Boolean.class.equals(klass)) {
            return klass.cast(Boolean.parseBoolean(paramValueStr));
        }
        if (Short.class.equals(klass)) {
            return klass.cast(Short.parseShort(paramValueStr));
        }
        if (Integer.class.equals(klass)) {
            return klass.cast(Integer.parseInt(paramValueStr));
        }
        if (Long.class.equals(klass)) {
            return klass.cast(Long.parseLong(paramValueStr));
        }
        if (Double.class.equals(klass)) {
            return klass.cast(Double.parseDouble(paramValueStr));
        }
        if (String.class.equals(klass)) {
            return klass.cast(paramValueStr);
        }
        throw new IllegalStateException("Could not convert type: " + klass.getName());
    }
}

