/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.impl.definition;

import io.ultreia.java4all.validation.impl.field.FieldValidator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FieldValidatorDefinition {
    private final String fieldName;
    private final String comment;
    private final Class<? extends FieldValidator<?, ?>> validator;
    private final Map<String, String> parameters;
    private final String message;

    public FieldValidatorDefinition(String fieldName, String comment, Class<? extends FieldValidator<?, ?>> validator, Map<String, String> parameters, String message) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.comment = Objects.requireNonNull(comment);
        this.validator = Objects.requireNonNull(validator);
        this.parameters = parameters;
        this.message = message;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getComment() {
        return this.comment;
    }

    public Class<? extends FieldValidator<?, ?>> getValidator() {
        return this.validator;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean withoutParameters() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public boolean withoutMessage() {
        return this.message == null || this.message.isEmpty();
    }

    public String getParameter(String parameterName) {
        return this.parameters == null ? null : this.parameters.get(parameterName);
    }

    public Optional<String> getOptionalParameter(String parameterName) {
        return Optional.ofNullable(this.parameters == null ? null : this.parameters.get(parameterName));
    }

    public boolean withoutParameter(String parameterName) {
        return this.parameters == null || this.parameters.get(parameterName) == null;
    }
}

