/*
 * #%L
 * Validation :: Impl
 * %%
 * Copyright (C) 2021 - 2024 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package io.ultreia.java4all.validation.impl.field;

import org.nuiton.validator.NuitonValidationContext;
import io.ultreia.java4all.validation.impl.ValidationMessagesCollector;

import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * @author Jean Couteau - couteau@codelutin.com
 * @since 2.3
 */
public class RequiredFieldValidator<O, F> extends SkipableFieldValidatorSupport<O, F> {

    public RequiredFieldValidator(String fieldName, Function<O, F> fieldFunction, BiFunction<O, NuitonValidationContext, Boolean> skipFunction) {
        super(fieldName, fieldFunction, skipFunction);
    }

    public RequiredFieldValidator(String fieldName,
                                  Function<O, F> fieldFunction,
                                  String messageKey,
                                  MessageBuilder<O, ? super NuitonValidationContext, ? super FieldValidator<O, ?>> messageBuilder,
                                  BiFunction<O, NuitonValidationContext, Boolean> skipFunction) {
        super(fieldName, fieldFunction, messageKey, messageBuilder, skipFunction);
    }

    @Override
    protected void validateWhenNotSkip(O object, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        F value = getField(object);
        if (value == null) {
            addMessage(validationContext, messagesCollector, getMessage(object, validationContext));
        }
    }
}
