package io.ultreia.java4all.validation.impl.definition;

/*-
 * #%L
 * Validation :: Impl
 * %%
 * Copyright (C) 2021 - 2024 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.validator.NuitonValidatorScope;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Describes the project validators file.
 * <p>
 * Created on 27/01/2024.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.0.0
 */
public class ProjectValidatorDefinition {

    private final Map<FileValidatorEntryDefinition, FileValidatorDefinition> filesByEntry;

    public ProjectValidatorDefinition(Map<FileValidatorEntryDefinition, FileValidatorDefinition> filesByEntry) {
        this.filesByEntry = Collections.unmodifiableMap(Objects.requireNonNull(filesByEntry));
    }

    public Map<FileValidatorEntryDefinition, FileValidatorDefinition> getFilesByEntry() {
        return filesByEntry;
    }

    public Stream<Map.Entry<FileValidatorEntryDefinition, FileValidatorDefinition>> filterByType(Class<?> type) {
        return getFilesByEntry()
                .entrySet()
                .stream()
                .filter(e -> e.getKey().getBeanType().isAssignableFrom(type));
    }

    public Stream<Map.Entry<FileValidatorEntryDefinition, FileValidatorDefinition>> filterByTypeContextAndScopes(Class<?> type, String context, Set<NuitonValidatorScope> scopes) {
        List<String> stringScopes = scopes.stream().map(NuitonValidatorScope::name).map(String::toLowerCase).collect(Collectors.toList());
        return getFilesByEntry()
                .entrySet()
                .stream()
                .filter(e -> e.getKey().getBeanType().isAssignableFrom(type) && Objects.equals(e.getKey().getContext(), context) && stringScopes.contains(e.getKey().getScope()));
    }

}
