package io.ultreia.java4all.validation.impl;

/*-
 * #%L
 * Validation :: Impl
 * %%
 * Copyright (C) 2021 - 2024 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.auto.service.AutoService;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorDefinition;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorDefinitionBuilder;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorMappingHelper;
import org.nuiton.validator.AbstractNuitonValidatorProvider;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created at 01/02/2024.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.0.0
 */
@AutoService(NuitonValidatorProvider.class)
public class NuitonValidatorProviderImpl extends AbstractNuitonValidatorProvider {
    public static final String PROVIDER_NAME = "default";
    private ProjectValidatorMapping mapping;
    private ProjectValidatorDefinition definitions;

    public NuitonValidatorProviderImpl() {
        super(PROVIDER_NAME);
    }

    @Override
    public <O> NuitonValidatorModel<O> newModel(Class<O> type, String context, NuitonValidatorScope... scopes) {
        if (scopes.length == 0) {
            // use all scopes
            scopes = NuitonValidatorScope.values();
        }
        Set<NuitonValidatorScope> scopeSet = EnumSet.copyOf(Arrays.asList(scopes));
        Map<NuitonValidatorScope, String[]> fields = new LinkedHashMap<>();
        definitions().filterByTypeContextAndScopes(type, context, scopeSet)
                     .map(Map.Entry::getValue)
                     .forEach(d -> fields.put(NuitonValidatorScope.valueOf(d.getScope().toUpperCase()), d.getFields().keySet().toArray(new String[0])));
        return new NuitonValidatorModel<>(type, context, scopeSet, fields);
    }

    @Override
    public <O> NuitonValidator<O> newValidator(NuitonValidatorModel<O> model) {
        return new NuitonValidatorImpl<>(this::mapping, model);
    }

    protected ProjectValidatorDefinition definitions() {
        if (definitions == null) {
            try {
                definitions = new ProjectValidatorDefinitionBuilder().buildAll();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return definitions;
    }

    protected ProjectValidatorMapping mapping() {
        if (mapping == null) {
            try {
                mapping = new ProjectValidatorMappingHelper().readAll();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return mapping;
    }
}
