/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldExpressionValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NuitonFieldExpressionValidator
extends FieldExpressionValidator {
    private static final Logger log = LogManager.getLogger(NuitonFieldExpressionValidator.class);
    protected String skip = "false";

    public void setSkip(String skip) {
        this.skip = skip;
    }

    protected void validateWhenNotSkip(Object object) throws ValidationException {
        super.validate(object);
    }

    public void validate(Object object) throws ValidationException {
        boolean mustSkip = this.evaluateSkipParameter(object);
        if (mustSkip) {
            if (log.isDebugEnabled()) {
                log.debug("Skip the validation from " + this + ", due to skip parameter evaluated to true");
            }
            return;
        }
        this.validateWhenNotSkip(object);
    }

    protected boolean evaluateSkipParameter(Object object) throws ValidationException {
        this.skip = this.skip.trim();
        if ("false".equals(this.skip)) {
            return false;
        }
        if ("true".equals(this.skip)) {
            return true;
        }
        try {
            Boolean answer = Boolean.FALSE;
            Object obj = this.getFieldValue(this.skip, object);
            if (obj != null && obj instanceof Boolean) {
                answer = (Boolean)obj;
            }
            return answer;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException("Can not evaluate boolean expression [" + this.skip + "] for reason " + e.getMessage());
        }
    }
}

