/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.validator.xwork2.field.FieldValidatorUtil;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchSiretFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final String SIRET_REGEXP = "[0-9]{14}";
    protected static final Pattern p = Pattern.compile("[0-9]{14}");

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        Object siret;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            siret = "";
            for (int i = 0; i < Array.getLength(value); ++i) {
                siret = (String)siret + String.valueOf(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            siret = "";
            for (Object o : (Collection)value) {
                siret = (String)siret + String.valueOf(o);
            }
        } else {
            siret = String.valueOf(value);
        }
        if (StringUtils.isEmpty((CharSequence)siret)) {
            return;
        }
        Matcher m = p.matcher((CharSequence)(siret = ((String)siret).replaceAll(" ", "")));
        if (!m.matches() || !FieldValidatorUtil.luhnChecksum((String)siret)) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchSiret";
    }
}

