/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.validator.xwork2.field.FieldValidatorUtil;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchSirenFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final String SIREN_REGEXP = "[0-9]{9}";
    protected static final Pattern p = Pattern.compile("[0-9]{9}");

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        Object siren;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            siren = "";
            for (int i = 0; i < Array.getLength(value); ++i) {
                siren = (String)siren + String.valueOf(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            siren = "";
            for (Object o : (Collection)value) {
                siren = (String)siren + String.valueOf(o);
            }
        } else {
            siren = String.valueOf(value);
        }
        if (StringUtils.isEmpty((CharSequence)siren)) {
            return;
        }
        Matcher m = p.matcher((CharSequence)(siren = ((String)siren).replaceAll(" ", "")));
        if (!m.matches() || !FieldValidatorUtil.luhnChecksum((String)siren)) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchSiret";
    }
}

