/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class CollectionUniqueKeyValidator
extends NuitonFieldValidatorSupport {
    private static final Logger log = LogManager.getLogger(CollectionUniqueKeyValidator.class);
    protected String collectionFieldName;
    protected String[] keys;
    protected String againstProperty;
    protected boolean againstMe;
    protected String againstIndexExpression;
    protected boolean nullValueSkipped;

    public String getCollectionFieldName() {
        return this.collectionFieldName;
    }

    public void setCollectionFieldName(String collectionFieldName) {
        this.collectionFieldName = collectionFieldName;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys != null && keys.length == 1 && keys[0].indexOf(44) != -1 ? keys[0].split(",") : keys;
    }

    public boolean getAgainstMe() {
        return this.againstMe;
    }

    public void setAgainstMe(boolean againstMe) {
        this.againstMe = againstMe;
    }

    public String getAgainstProperty() {
        return this.againstProperty;
    }

    public void setAgainstProperty(String againstProperty) {
        this.againstProperty = againstProperty;
    }

    public String getAgainstIndexExpression() {
        return this.againstIndexExpression;
    }

    public void setAgainstIndexExpression(String againstIndexExpression) {
        this.againstIndexExpression = againstIndexExpression;
    }

    public boolean isNullValueSkipped() {
        return this.nullValueSkipped;
    }

    public void setNullValueSkipped(boolean nullValueSkipped) {
        this.nullValueSkipped = nullValueSkipped;
    }

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        Integer againstHashCode;
        Integer againstIndex;
        Object againstBean;
        if (this.keys == null || this.keys.length == 0) {
            throw new ValidationException("no unique keys defined");
        }
        String fieldName = this.getFieldName();
        Collection<?> col = this.getCollection(object);
        if (log.isDebugEnabled()) {
            log.debug("collection found : " + col);
        }
        Object object2 = againstBean = this.againstProperty == null ? null : this.getFieldValue(this.againstProperty, object);
        if (log.isDebugEnabled()) {
            log.debug("againtBean = " + againstBean);
        }
        Integer n = againstIndex = this.againstIndexExpression == null ? Integer.valueOf(-1) : this.getFieldValue(this.againstIndexExpression, object);
        if (againstIndex == null) {
            againstIndex = -1;
        }
        if (!this.againstMe && againstBean == null && col.size() < 2) {
            return;
        }
        if (this.againstMe) {
            againstBean = object;
            if (log.isDebugEnabled()) {
                log.debug("againtBean from me = " + againstBean);
            }
        }
        boolean answer = true;
        Integer n2 = againstHashCode = againstBean == null ? null : this.getUniqueKeyHashCode(againstBean);
        if (log.isDebugEnabled()) {
            log.debug("hash for new key " + againstHashCode);
        }
        if (againstHashCode == null && this.nullValueSkipped) {
            return;
        }
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        int index = 0;
        for (Object o : col) {
            Integer hash = this.getUniqueKeyHashCode(o);
            if (log.isDebugEnabled()) {
                log.debug("hash for object  " + o + " = " + hash);
            }
            if (hash == null && this.nullValueSkipped) continue;
            if (againstBean == null) {
                if (hashCodes.contains(hash)) {
                    answer = false;
                    if (!log.isDebugEnabled()) break;
                    log.debug("Found same hashcode, not unique!");
                    break;
                }
            } else if (againstIndex != -1) {
                if (index != againstIndex && hash.equals(againstHashCode)) {
                    answer = false;
                    break;
                }
            } else if (!againstBean.equals(o) && hash.equals(againstHashCode)) {
                answer = false;
                break;
            }
            hashCodes.add(hash);
            ++index;
        }
        if (!answer) {
            this.addFieldError(fieldName, object);
        }
    }

    protected Integer getUniqueKeyHashCode(Object o) throws ValidationException {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (String key : this.keys) {
            Object property = this.getFieldValue(key, o);
            if (property == null && this.nullValueSkipped) {
                return null;
            }
            builder.append(property);
        }
        return builder.toHashCode();
    }

    protected Collection<?> getCollection(Object object) throws ValidationException {
        String fieldName = this.getCollectionFieldName();
        if (fieldName == null || fieldName.trim().isEmpty()) {
            fieldName = this.getFieldName();
        }
        Object obj = null;
        try {
            obj = this.getFieldValue(fieldName, object);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj == null) {
            return Collections.emptyList();
        }
        if (!Collection.class.isInstance(obj)) {
            throw new ValidationException("field " + fieldName + " is not a collection type! (" + obj.getClass() + ")");
        }
        return (Collection)obj;
    }

    public String getValidatorType() {
        return "collectionUniqueKey";
    }
}

