/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.BeanUtil;
import org.nuiton.validator.xwork2.XWork2ScopeValidator;

public class XWork2ValidatorUtil {
    private static final Logger log = LogManager.getLogger(XWork2ValidatorUtil.class);
    private static ValueStack sharedValueStack;

    public static ValueStack getSharedValueStack() {
        if (sharedValueStack == null) {
            sharedValueStack = XWork2ValidatorUtil.createValueStack();
            if (log.isDebugEnabled()) {
                log.debug("init shared value stack " + sharedValueStack);
            }
        }
        return sharedValueStack;
    }

    public static void setSharedValueStack(ValueStack sharedValueStack) {
        if (log.isDebugEnabled()) {
            log.debug("set shared value stack " + sharedValueStack);
        }
        XWork2ValidatorUtil.sharedValueStack = sharedValueStack;
    }

    public static ValueStack createValueStack() {
        ValueStack result;
        ActionContext context = ActionContext.getContext();
        if (context == null) {
            ConfigurationManager confManager = new ConfigurationManager("xwork");
            Configuration conf = confManager.getConfiguration();
            Container container = conf.getContainer();
            ValueStackFactory stackFactory = (ValueStackFactory)container.getInstance(ValueStackFactory.class);
            result = stackFactory.createValueStack();
        } else {
            result = context.getValueStack();
            if (result == null) {
                ValueStackFactory stackFactory = (ValueStackFactory)context.getInstance(ValueStackFactory.class);
                result = stackFactory.createValueStack();
            }
        }
        return result;
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields) {
        return XWork2ValidatorUtil.newXWorkScopeValidator(beanClass, contextName, fields, XWork2ValidatorUtil.getSharedValueStack());
    }

    public static <O> XWork2ScopeValidator<O> newXWorkScopeValidator(Class<O> beanClass, String contextName, Set<String> fields, ValueStack vs) {
        return new XWork2ScopeValidator<O>(beanClass, contextName, fields, vs);
    }

    public static String getContextForScope(String context, NuitonValidatorScope scope) {
        return (String)(context == null ? "" : context + "-") + scope.name().toLowerCase();
    }

    protected static ActionValidatorManager newValidationManager(ValueStack vs) {
        ActionContext context;
        if (vs == null) {
            vs = XWork2ValidatorUtil.createValueStack();
            if (log.isDebugEnabled()) {
                log.debug("create a standalone value stack " + vs);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("use given value stack " + vs);
        }
        if ((context = ActionContext.getContext()) == null) {
            context = new ActionContext(vs.getContext());
            ActionContext.setContext((ActionContext)context);
        }
        Container container = context.getContainer();
        if (context.getActionInvocation() == null) {
            HashMap<String, ValueStack> extraContext = new HashMap<String, ValueStack>();
            extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", vs);
            DefaultActionInvocation invocation = new DefaultActionInvocation(extraContext, false);
            invocation.setObjectFactory((ObjectFactory)container.getInstance(ObjectFactory.class));
            invocation.setContainer(container);
            ActionProxyFactory actionProxyFactory = (ActionProxyFactory)context.getInstance(ActionProxyFactory.class);
            ActionProxy actionProxy = actionProxyFactory.createActionProxy((ActionInvocation)invocation, "java.lang", "java.lang.Object", null, false, false);
            invocation.init(actionProxy);
            context.setActionInvocation((ActionInvocation)invocation);
        }
        return (ActionValidatorManager)container.getInstance(ActionValidatorManager.class, "no-annotations");
    }

    public static <O> Map<NuitonValidatorScope, String[]> detectFields(Class<O> type, String context, NuitonValidatorScope[] scopeUniverse) {
        Set availableFields = BeanUtil.getReadableProperties(type);
        ActionValidatorManager validatorManager = XWork2ValidatorUtil.newValidationManager(XWork2ValidatorUtil.getSharedValueStack());
        TreeMap<NuitonValidatorScope, String[]> fields = new TreeMap<NuitonValidatorScope, String[]>();
        for (NuitonValidatorScope scope : scopeUniverse) {
            Set<String> fieldNames = XWork2ValidatorUtil.detectFieldsForScope(validatorManager, type, scope, context, availableFields, false);
            log.debug(String.format("detected validator fields for scope %s:%s : %s", scope, context, fieldNames));
            if (fieldNames.isEmpty()) continue;
            fields.put(scope, fieldNames.toArray(new String[0]));
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFieldError(FieldValidatorSupport validator, ValueStack stack, String propertyName, Object object) {
        boolean pop = false;
        if (!stack.getRoot().contains((Object)validator)) {
            stack.push((Object)validator);
            pop = true;
        }
        try {
            validator.getValidatorContext().addFieldError(propertyName, validator.getMessage(object));
        }
        finally {
            if (pop) {
                stack.pop();
            }
        }
    }

    protected static Set<String> detectFieldsForScope(ActionValidatorManager validator, Class<?> type, NuitonValidatorScope scope, String context, Set<String> availableFields, boolean includeDefaultContext) {
        String scopeContext = XWork2ValidatorUtil.getContextForScope(context, scope);
        HashSet<String> fields = new HashSet<String>();
        int skip = 0;
        if (!includeDefaultContext) {
            for (Validator v : validator.getValidators(type, null)) {
                if (!(v instanceof FieldValidator)) continue;
                ++skip;
            }
        }
        for (Validator v : validator.getValidators(type, scopeContext)) {
            if (!(v instanceof FieldValidator)) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            FieldValidator fieldValidator = (FieldValidator)v;
            log.debug(String.format("context %s - field %s", context, fieldValidator.getFieldName()));
            String fName = fieldValidator.getFieldName();
            if (availableFields.contains(fName)) {
                fields.add(fName);
                continue;
            }
            if (BeanUtil.isNestedReadableProperty(type, (String)fName)) {
                fields.add(fName);
                continue;
            }
            String message = String.format("Field %s in scope [%s] is not a readable property of %s", fName, scopeContext, type.getName());
            if (log.isErrorEnabled()) {
                log.error(message);
            }
            throw new IllegalStateException(message);
        }
        return fields;
    }

    public static class NuitonDefaultUnknownHandler
    implements UnknownHandler {
        protected Configuration configuration;
        protected ObjectFactory objectFactory;

        @Inject
        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        @Inject
        public void setObjectFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public ActionConfig handleUnknownAction(String namespace, String actionName) {
            return new ActionConfig.Builder(namespace, actionName, Object.class.getName()).build();
        }

        public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) {
            return null;
        }

        public Object handleUnknownActionMethod(Object action, String methodName) {
            return null;
        }
    }
}

