/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.DefaultLocaleProvider;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.validator.AbstractNuitonScopeValidator;
import org.nuiton.validator.NuitonValidationContext;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public class XWork2ScopeValidator<O>
extends AbstractNuitonScopeValidator<O> {
    protected static final Map<String, List<String>> EMPTY_RESULT = Collections.unmodifiableMap(new HashMap());
    private static final Logger log = LogManager.getLogger(XWork2ScopeValidator.class);
    protected ValidationAwareSupport validationSupport = new ValidationAwareSupport();
    protected DelegatingValidatorContext validationContext;
    protected ActionValidatorManager validator;
    protected ValueStack vs;

    protected XWork2ScopeValidator(Class<O> type, String context, Set<String> fieldNames, ValueStack vs) {
        super(type, context, fieldNames);
        if (vs == null) {
            vs = XWork2ValidatorUtil.createValueStack();
        }
        this.vs = vs;
        TextProvider textProvider = null;
        for (Object o : vs.getRoot()) {
            if (!(o instanceof TextProvider)) continue;
            textProvider = (TextProvider)o;
            break;
        }
        if (textProvider == null) {
            throw new NullPointerException("Could not find textProvider in stack.");
        }
        this.validationContext = new DelegatingValidatorContext((ValidationAware)this.validationSupport, textProvider, (LocaleProvider)new DefaultLocaleProvider());
        this.validator = XWork2ValidatorUtil.newValidationManager(vs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> validate(O bean, NuitonValidationContext validationContext) {
        if (bean == null) {
            throw new NullPointerException("bean parameter can not be null in method validate");
        }
        Map<String, List<String>> result = EMPTY_RESULT;
        if (this.getFieldNames().isEmpty()) {
            return result;
        }
        try {
            if (ActionContext.getContext() == null) {
                ActionContext.setContext((ActionContext)new ActionContext(this.vs.getContext()));
            }
            this.validator.validate(bean, this.getContext(), (ValidatorContext)this.validationContext);
            if (log.isTraceEnabled()) {
                log.trace("Action errors: " + this.validationContext.getActionErrors());
                log.trace("Action messages: " + this.validationContext.getActionMessages());
                log.trace("Field errors: " + this.validationContext.getFieldErrors());
            }
            if (log.isDebugEnabled()) {
                log.debug(this + " : " + this.validationContext.getFieldErrors());
            }
            if (this.validationContext.hasFieldErrors()) {
                Map messages = this.validationContext.getFieldErrors();
                result = new HashMap<String, List<String>>(messages.size());
                for (Object fieldName : messages.keySet()) {
                    Collection c = (Collection)messages.get(fieldName);
                    ArrayList<String> mm = new ArrayList<String>(c.size());
                    for (Object message : c) {
                        Object messageStr = message == null ? "" : "" + message;
                        mm.add(((String)messageStr).trim());
                    }
                    result.put("" + fieldName, mm);
                }
            }
        }
        catch (ValidationException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error during validation on " + this.type + " for reason : " + eee.getMessage(), (Throwable)eee);
            }
        }
        finally {
            this.validationSupport.clearErrorsAndMessages();
        }
        return result;
    }

    public ActionValidatorManager getValidator() {
        return this.validator;
    }
}

