/*
 * #%L
 * Validation :: API
 * %%
 * Copyright (C) 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Validate post codes for French cities
 * <p>
 * - Take into account 2A and 2B
 * - Take into account DOMs and TOMs
 * - Postcodes starting with 99 are not valid
 *
 * @author Jean Couteau - couteau@codelutin.com
 * @since 2.3
 */
public class FrenchPostCodeFieldValidator extends NuitonFieldValidatorSupport {

    protected static String POST_CODE_REGEXP =
            "^((0[1-9])|([1-8][0-9])|(9[0-8])|(2A)|(2B))[0-9]{3}$";

    protected static Pattern p = Pattern.compile(POST_CODE_REGEXP);

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {

        String fieldName = getFieldName();
        Object value = getFieldValue(fieldName, object);

        if (value == null) {
            // no value defined
            return;
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                // no value defined
                return;
            }
            Matcher m = p.matcher((String) value);
            if (!m.matches()) {
                addFieldError(fieldName, object);
            }
        } else {
            addFieldError(fieldName, object);
        }
    }

    @Override
    public String getValidatorType() {
        return "frenchPostCode";
    }
}
