/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.validator.xwork2.field.FieldValidatorUtil;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchFinessFieldValidator
extends NuitonFieldValidatorSupport {
    protected static final String FINESS_REGEXP = "(0[1-9]|[1-9][0-9]|2A|2B)0([0-9]{6})";
    protected static final Pattern p = Pattern.compile("(0[1-9]|[1-9][0-9]|2A|2B)0([0-9]{6})");

    @Override
    protected void validateWhenNotSkip(Object object) throws ValidationException {
        Object finess;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            finess = "";
            for (int i = 0; i < Array.getLength(value); ++i) {
                finess = (String)finess + String.valueOf(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            finess = "";
            for (Object o : (Collection)value) {
                finess = (String)finess + String.valueOf(o);
            }
        } else {
            finess = String.valueOf(value);
        }
        if (StringUtils.isEmpty((CharSequence)finess)) {
            return;
        }
        Matcher m = p.matcher((CharSequence)(finess = ((String)finess).replaceAll(" ", "")));
        if (!m.matches() || !FieldValidatorUtil.luhnChecksum((String)finess)) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchFiness";
    }
}

