/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.util.StringUtils;

public class JGitFlowVersionInfo
implements VersionInfo {
    private final String strVersion;
    private final List<String> digits;
    private String annotation;
    private String annotationRevision;
    private final String buildSpecifier;
    private String annotationSeparator;
    private String annotationRevSeparator;
    private final String buildSeparator;
    private static final int DIGITS_INDEX = 1;
    private static final int ANNOTATION_SEPARATOR_INDEX = 2;
    private static final int ANNOTATION_INDEX = 3;
    private static final int ANNOTATION_REV_SEPARATOR_INDEX = 4;
    private static final int ANNOTATION_REVISION_INDEX = 5;
    private static final int BUILD_SEPARATOR_INDEX = 6;
    private static final int BUILD_SPECIFIER_INDEX = 7;
    private static final String SNAPSHOT_IDENTIFIER = "SNAPSHOT";
    private static final String DIGIT_SEPARATOR_STRING = ".";
    public static final Pattern STANDARD_PATTERN = Pattern.compile("^((?:\\d+\\.)*\\d+)([-_])?([a-zA-Z]*)([-_])?(\\d*)(?:([-_])?(.*?))?$");
    public static final Pattern ALTERNATE_PATTERN = Pattern.compile("^(SNAPSHOT|[a-zA-Z]+[_-]SNAPSHOT)");

    public JGitFlowVersionInfo(String version) throws VersionParseException {
        this.strVersion = version;
        Matcher matcher = ALTERNATE_PATTERN.matcher(this.strVersion);
        if (matcher.matches()) {
            this.annotation = null;
            this.digits = null;
            this.buildSpecifier = version;
            this.buildSeparator = null;
            return;
        }
        Matcher m = STANDARD_PATTERN.matcher(this.strVersion);
        if (m.matches()) {
            this.digits = this.parseDigits(m.group(1));
            if (!SNAPSHOT_IDENTIFIER.equals(m.group(3))) {
                this.annotationSeparator = m.group(2);
                this.annotation = JGitFlowVersionInfo.nullIfEmpty(m.group(3));
                if (StringUtils.isNotEmpty((String)m.group(4)) && StringUtils.isEmpty((String)m.group(5))) {
                    this.buildSeparator = m.group(4);
                    this.buildSpecifier = JGitFlowVersionInfo.nullIfEmpty(m.group(7));
                } else {
                    this.annotationRevSeparator = m.group(4);
                    this.annotationRevision = JGitFlowVersionInfo.nullIfEmpty(m.group(5));
                    this.buildSeparator = m.group(6);
                    this.buildSpecifier = JGitFlowVersionInfo.nullIfEmpty(m.group(7));
                }
            } else {
                this.buildSeparator = m.group(2);
                this.buildSpecifier = JGitFlowVersionInfo.nullIfEmpty(m.group(3));
            }
        } else {
            throw new VersionParseException("Unable to parse the version string: \"" + version + "\"");
        }
    }

    public JGitFlowVersionInfo(List<String> digits, String annotation, String annotationRevision, String buildSpecifier, String annotationSeparator, String annotationRevSeparator, String buildSeparator) {
        this.digits = digits;
        this.annotation = annotation;
        this.annotationRevision = annotationRevision;
        this.buildSpecifier = buildSpecifier;
        this.annotationSeparator = annotationSeparator;
        this.annotationRevSeparator = annotationRevSeparator;
        this.buildSeparator = buildSeparator;
        this.strVersion = JGitFlowVersionInfo.getVersionString(this, buildSpecifier, buildSeparator);
    }

    public boolean isSnapshot() {
        return ArtifactUtils.isSnapshot((String)this.strVersion);
    }

    public VersionInfo getNextVersion() {
        JGitFlowVersionInfo version = null;
        if (this.digits != null) {
            ArrayList<String> digits = new ArrayList<String>(this.digits);
            String annotationRevision = this.annotationRevision;
            if (StringUtils.isNumeric((String)annotationRevision)) {
                annotationRevision = this.incrementVersionString(annotationRevision);
            } else {
                digits.set(digits.size() - 1, this.incrementVersionString((String)digits.get(digits.size() - 1)));
            }
            version = new JGitFlowVersionInfo(digits, this.annotation, annotationRevision, this.buildSpecifier, this.annotationSeparator, this.annotationRevSeparator, this.buildSeparator);
        }
        return version;
    }

    public int compareTo(VersionInfo obj) {
        int result;
        JGitFlowVersionInfo that = (JGitFlowVersionInfo)obj;
        if (this.strVersion.startsWith(that.strVersion) && !this.strVersion.equals(that.strVersion) && this.strVersion.charAt(that.strVersion.length()) != '-') {
            result = 1;
        } else if (that.strVersion.startsWith(this.strVersion) && !this.strVersion.equals(that.strVersion) && that.strVersion.charAt(this.strVersion.length()) != '-') {
            result = -1;
        } else {
            String thisVersion = this.strVersion.toUpperCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            String thatVersion = that.strVersion.toUpperCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            result = new DefaultArtifactVersion(thisVersion).compareTo((Object)new DefaultArtifactVersion(thatVersion));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JGitFlowVersionInfo)) {
            return false;
        }
        return this.compareTo((VersionInfo)obj) == 0;
    }

    protected String incrementVersionString(String s) {
        int n = Integer.valueOf(s) + 1;
        String value = String.valueOf(n);
        if (value.length() < s.length()) {
            value = StringUtils.leftPad((String)value, (int)s.length(), (String)"0");
        }
        return value;
    }

    public String getSnapshotVersionString() {
        if (this.strVersion.equals(SNAPSHOT_IDENTIFIER)) {
            return this.strVersion;
        }
        String baseVersion = this.getReleaseVersionString();
        if (baseVersion.length() > 0) {
            baseVersion = baseVersion + "-";
        }
        return baseVersion + SNAPSHOT_IDENTIFIER;
    }

    public String getReleaseVersionString() {
        String baseVersion = this.strVersion;
        Matcher m = Artifact.VERSION_FILE_PATTERN.matcher(baseVersion);
        if (m.matches()) {
            baseVersion = m.group(1);
        } else if (StringUtils.right((String)baseVersion, (int)9).equalsIgnoreCase("-SNAPSHOT")) {
            baseVersion = baseVersion.substring(0, baseVersion.length() - SNAPSHOT_IDENTIFIER.length() - 1);
        } else if (baseVersion.equals(SNAPSHOT_IDENTIFIER)) {
            baseVersion = "1.0";
        }
        return baseVersion;
    }

    public String getHotfixVersionString() {
        JGitFlowVersionInfo version = null;
        if (this.digits != null) {
            ArrayList<String> digits = new ArrayList<String>(this.digits);
            if (digits.size() == 0) {
                digits.add("0");
                digits.add("0");
                digits.add("1");
            } else if (digits.size() == 1) {
                digits.add("0");
                digits.add("1");
            } else if (digits.size() == 2) {
                digits.add("1");
            } else if (digits.size() == 3) {
                int newBugfixDigit = Integer.parseInt((String)digits.get(2)) + 1;
                digits.set(2, String.valueOf(newBugfixDigit));
            } else {
                digits.add("hotfix");
            }
            version = new JGitFlowVersionInfo(digits, this.annotation, this.annotationRevision, this.buildSpecifier, this.annotationSeparator, this.annotationRevSeparator, this.buildSeparator);
        }
        return version.getReleaseVersionString();
    }

    public VersionInfo getNextDevelopmentVersion(int indexOfDigitsToIncrement) {
        JGitFlowVersionInfo version = null;
        if (this.digits != null) {
            ArrayList<String> digits = new ArrayList<String>(this.digits);
            String annotationRevision = this.annotationRevision;
            if (indexOfDigitsToIncrement == 0) {
                int newMajorVersion = Integer.parseInt((String)digits.get(0)) + 1;
                digits.set(0, String.valueOf(newMajorVersion));
                this.rebase(digits, 1);
            } else if (indexOfDigitsToIncrement == 1) {
                int newMinorVersion = Integer.parseInt((String)digits.get(1)) + 1;
                digits.set(1, String.valueOf(newMinorVersion));
                this.rebase(digits, 2);
            } else if (StringUtils.isNumeric((String)annotationRevision)) {
                annotationRevision = this.incrementVersionString(annotationRevision);
            } else {
                digits.set(digits.size() - 1, this.incrementVersionString((String)digits.get(digits.size() - 1)));
            }
            version = new JGitFlowVersionInfo(digits, this.annotation, annotationRevision, this.buildSpecifier, this.annotationSeparator, this.annotationRevSeparator, this.buildSeparator);
        }
        return version;
    }

    private void rebase(List<String> digits, int rebaseStartIndex) {
        for (int i = rebaseStartIndex; i < digits.size(); ++i) {
            digits.set(i, "0");
        }
    }

    public String getDecrementedHotfixVersionString() {
        JGitFlowVersionInfo version = null;
        if (this.digits != null) {
            ArrayList<String> digits = new ArrayList<String>(this.digits);
            String lastDigit = (String)digits.get(digits.size() - 1);
            int n = Integer.valueOf(lastDigit);
            if (n > 0) {
                digits.set(digits.size() - 1, Integer.toString(n - 1));
                digits.add("1");
            } else {
                digits.set(digits.size() - 1, "1");
            }
            version = new JGitFlowVersionInfo(digits, this.annotation, this.annotationRevision, this.buildSpecifier, this.annotationSeparator, this.annotationRevSeparator, this.buildSeparator);
        }
        return version.getReleaseVersionString();
    }

    public String toString() {
        return this.strVersion;
    }

    protected static String getVersionString(JGitFlowVersionInfo info, String buildSpecifier, String buildSeparator) {
        StringBuilder sb = new StringBuilder();
        if (info.digits != null) {
            sb.append(JGitFlowVersionInfo.joinDigitString(info.digits));
        }
        if (StringUtils.isNotEmpty((String)info.annotation)) {
            sb.append(StringUtils.defaultString((Object)info.annotationSeparator));
            sb.append(info.annotation);
        }
        if (StringUtils.isNotEmpty((String)info.annotationRevision)) {
            if (StringUtils.isEmpty((String)info.annotation)) {
                sb.append(StringUtils.defaultString((Object)info.annotationSeparator));
            } else {
                sb.append(StringUtils.defaultString((Object)info.annotationRevSeparator));
            }
            sb.append(info.annotationRevision);
        }
        if (StringUtils.isNotEmpty((String)buildSpecifier)) {
            sb.append(StringUtils.defaultString((Object)buildSeparator));
            sb.append(buildSpecifier);
        }
        return sb.toString();
    }

    protected static String joinDigitString(List<String> digits) {
        return digits != null ? StringUtils.join(digits.iterator(), (String)DIGIT_SEPARATOR_STRING) : null;
    }

    private List<String> parseDigits(String strDigits) {
        return Arrays.asList(StringUtils.split((String)strDigits, (String)DIGIT_SEPARATOR_STRING));
    }

    private static String nullIfEmpty(String s) {
        return StringUtils.isEmpty((String)s) ? null : s;
    }

    public List<String> getDigits() {
        return this.digits;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getAnnotationRevision() {
        return this.annotationRevision;
    }

    public String getBuildSpecifier() {
        return this.buildSpecifier;
    }
}

