/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.util;

import com.atlassian.maven.plugins.jgitflow.PrettyPrompter;
import com.atlassian.maven.plugins.jgitflow.util.SshUserInfo;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class SshCredentialsProvider
extends JschConfigSessionFactory {
    private PrettyPrompter prompter;
    private final Logger logger;

    public SshCredentialsProvider(PrettyPrompter prompter, Logger logger) {
        this.prompter = prompter;
        this.logger = logger;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        session.setConfig("StrictHostKeyChecking", "no");
        session.setUserInfo((UserInfo)new SshUserInfo(this.prompter));
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        SSHAgentConnector con = null;
        JSch jsch = null;
        try {
            if (SSHAgentConnector.isConnectorAvailable()) {
                JNAUSocketFactory usf = new JNAUSocketFactory();
                con = new SSHAgentConnector((USocketFactory)usf);
            }
        }
        catch (AgentProxyException e) {
            this.logger.warn("Error connecting to ssh-agent: " + e.getMessage());
        }
        if (null == con) {
            this.logger.info("Use default SSH connector");
            jsch = super.createDefaultJSch(fs);
            return jsch;
        }
        this.logger.info("Use ssh-agent connector");
        jsch = new JSch();
        JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
        RemoteIdentityRepository irepo = new RemoteIdentityRepository((Connector)con);
        jsch.setIdentityRepository((IdentityRepository)irepo);
        this.knownHosts(jsch, fs);
        AgentProxy ap = new AgentProxy((Connector)con);
        this.identities(jsch, fs, ap);
        return jsch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void knownHosts(JSch sch, FS fs) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try (FileInputStream in = new FileInputStream(known_hosts);){
            sch.setKnownHosts((InputStream)in);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void identities(JSch sch, FS fs, AgentProxy ap) {
        if (ap.getIdentities().length > 0) {
            this.logger.info("ssh-agent already has some identities which are reused");
            return;
        }
        this.logger.info("ssh-agent does not yet have an identity, adding the default OpenSSH ones");
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            this.loadIdentity(sch, new File(sshdir, "identity"));
            this.loadIdentity(sch, new File(sshdir, "id_rsa"));
            this.loadIdentity(sch, new File(sshdir, "id_dsa"));
        }
    }

    private void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }
}

