/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ParentReleaseVersionChange
implements ProjectChange {
    private final Map<String, String> originalVersions;
    private final Map<String, String> releaseVersions;
    private final boolean consistentProjectVersions;
    private final List<String> workLog;

    private ParentReleaseVersionChange(Map<String, String> originalVersions, Map<String, String> releaseVersions, boolean consistentProjectVersions) {
        this.originalVersions = originalVersions;
        this.releaseVersions = releaseVersions;
        this.consistentProjectVersions = consistentProjectVersions;
        this.workLog = new ArrayList<String>();
    }

    public static ParentReleaseVersionChange parentReleaseVersionChange(Map<String, String> originalVersions, Map<String, String> releaseVersions, boolean consistentProjectVersions) {
        return new ParentReleaseVersionChange(originalVersions, releaseVersions, consistentProjectVersions);
    }

    @Override
    public boolean applyChange(MavenProject project, Element root, String eol) throws ProjectRewriteException {
        boolean modified = false;
        if (project.hasParent()) {
            Namespace ns = ProjectChangeUtils.getNamespaceOrNull(root);
            Element parentVersionElement = root.getChild("parent", ns).getChild("version", ns);
            MavenProject parent = project.getParent();
            String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
            if (this.originalVersions.get(parentId) != null) {
                String parentVersion = this.releaseVersions.get(parentId);
                if (null == parentVersion && this.consistentProjectVersions && this.releaseVersions.size() > 0) {
                    parentVersion = this.releaseVersions.values().iterator().next();
                }
                if (null == parentVersion) {
                    if (parent.getVersion().equals(this.originalVersions.get(parentId))) {
                        throw new ProjectRewriteException("Release version for parent " + parent.getName() + " was not found");
                    }
                } else {
                    this.workLog.add("setting parent version to '" + parentVersion + "'");
                    parentVersionElement.setText(parentVersion);
                    modified = true;
                }
            }
        }
        return modified;
    }

    public String toString() {
        if (this.workLog.isEmpty()) {
            return "[Update Parent Release Version]";
        }
        return "[Update Parent Release Version]\n - " + Joiner.on((String)"\n - ").join(this.workLog);
    }
}

