/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.command.ReleaseFinishCommand;
import com.atlassian.jgitflow.core.command.ReleaseStartCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.extension.ReleaseFinishExtension;
import com.atlassian.jgitflow.core.extension.ReleaseStartExtension;
import com.atlassian.maven.jgitflow.api.MavenJGitFlowExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.extension.ReleaseFinishPluginExtension;
import com.atlassian.maven.plugins.jgitflow.extension.ReleaseStartPluginExtension;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractProductionBranchManager;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=FlowReleaseManager.class, hint="release")
public class DefaultFlowReleaseManager
extends AbstractProductionBranchManager {
    @Requirement
    private ReleaseStartPluginExtension startExtension;
    @Requirement
    private ReleaseFinishPluginExtension finishExtension;

    public DefaultFlowReleaseManager() {
        super(BranchType.RELEASE);
    }

    @Override
    public void start(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            String releaseLabel = this.getStartLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            this.startExtension.init((MavenJGitFlowExtension)ctx.getReleaseStartExtension());
            ((ReleaseStartCommand)((ReleaseStartCommand)((ReleaseStartCommand)((ReleaseStartCommand)((ReleaseStartCommand)flow.releaseStart(releaseLabel).setAllowUntracked(ctx.isAllowUntracked())).setPush(ctx.isPushReleases())).setStartCommit(ctx.getStartCommit())).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setExtension((ReleaseStartExtension)this.startExtension).call();
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error starting release: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                JGitFlowReporter.get().flush();
            }
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            this.finishExtension.init((MavenJGitFlowExtension)ctx.getReleaseFinishExtension());
            String releaseLabel = this.getFinishLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            JGitFlowReporter reporter = JGitFlowReporter.get();
            MavenProject originalRootProject = ReleaseUtil.getRootProject(reactorProjects);
            this.getLogger().info("running jgitflow release finish...");
            ReleaseMergeResult mergeResult = ((ReleaseFinishCommand)((ReleaseFinishCommand)((ReleaseFinishCommand)((ReleaseFinishCommand)((ReleaseFinishCommand)((ReleaseFinishCommand)flow.releaseFinish(releaseLabel).setPush(ctx.isPushReleases())).setKeepBranch(ctx.isKeepBranch())).setNoTag(ctx.isNoTag()).setSquash(ctx.isSquash()).setAllowUntracked(ctx.isAllowUntracked())).setNoMerge(ctx.isNoReleaseMerge()).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setAddScmCommentSuffixOnMerge(ctx.isAddScmCommentSuffixOnMerge())).setExtension((ReleaseFinishExtension)this.finishExtension).call();
            if (!mergeResult.wasSuccessful()) {
                if (mergeResult.masterHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getMasterBranchName() + ":");
                    this.getLogger().error(mergeResult.getMasterResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                if (mergeResult.developHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getDevelopBranchName() + ":");
                    this.getLogger().error(mergeResult.getDevelopResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                throw new MavenJGitFlowException("Error while merging release!");
            }
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error finishing release: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                JGitFlowReporter.get().flush();
            }
        }
    }
}

