/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.FeatureFinishCommand;
import com.atlassian.jgitflow.core.command.FeatureStartCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.extension.FeatureFinishExtension;
import com.atlassian.jgitflow.core.extension.FeatureStartExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.extension.FeatureFinishPluginExtension;
import com.atlassian.maven.plugins.jgitflow.extension.FeatureStartPluginExtension;
import com.atlassian.maven.plugins.jgitflow.helper.MavenExecutionHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.SessionAndProjects;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractFlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.provider.BranchLabelProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.util.NamingUtil;
import com.google.common.base.Splitter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

@Component(role=FlowReleaseManager.class, hint="feature")
public class DefaultFlowFeatureManager
extends AbstractFlowReleaseManager {
    @Requirement
    private MavenExecutionHelper mavenExecutionHelper;
    @Requirement
    private BranchLabelProvider labelProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private FeatureStartPluginExtension startExtension;
    @Requirement
    private FeatureFinishPluginExtension finishExtension;

    @Override
    public void start(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            String featureName = this.getStartLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            this.startExtension.init();
            ((FeatureStartCommand)((FeatureStartCommand)((FeatureStartCommand)((FeatureStartCommand)((FeatureStartCommand)flow.featureStart(featureName).setAllowUntracked(ctx.isAllowUntracked())).setPush(ctx.isPushFeatures())).setStartCommit(ctx.getStartCommit())).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setExtension((FeatureStartExtension)this.startExtension).call();
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error starting feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                JGitFlowReporter.get().flush();
            }
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            this.finishExtension.init();
            String featureLabel = this.getFinishLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            JGitFlowReporter reporter = JGitFlowReporter.get();
            this.getLogger().info("running jgitflow feature finish...");
            MergeResult mergeResult = ((FeatureFinishCommand)((FeatureFinishCommand)((FeatureFinishCommand)((FeatureFinishCommand)((FeatureFinishCommand)flow.featureFinish(featureLabel).setKeepBranch(ctx.isKeepBranch())).setSquash(ctx.isSquash()).setRebase(ctx.isFeatureRebase()).setAllowUntracked(ctx.isAllowUntracked())).setPush(ctx.isPushFeatures())).setNoMerge(ctx.isNoFeatureMerge()).setSuppressFastForward(ctx.isSuppressFastForward()).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setExtension((FeatureFinishExtension)this.finishExtension).call();
            if (!mergeResult.getMergeStatus().isSuccessful()) {
                this.getLogger().error("Error merging into " + flow.getDevelopBranchName() + ":");
                this.getLogger().error(mergeResult.toString());
                this.getLogger().error("see .git/jgitflow.log for more info");
                throw new MavenJGitFlowException("Error while merging feature!");
            }
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error finish feature: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new MavenJGitFlowException("Error finish feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                JGitFlowReporter.get().flush();
            }
        }
    }

    @Override
    public void deploy(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session, String buildNumber, String goals) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            String featureLabel = this.getFinishLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            JGitFlowReporter reporter = JGitFlowReporter.get();
            SessionAndProjects sessionAndProjects = this.checkoutAndGetProjects.run(flow.getFeatureBranchPrefix() + featureLabel);
            List<MavenProject> featureProjects = sessionAndProjects.getProjects();
            MavenSession featureSession = sessionAndProjects.getSession();
            String featureVersion = NamingUtil.camelCaseOrSpaceToDashed(featureLabel);
            featureVersion = StringUtils.replace((String)featureVersion, (String)"-", (String)"_");
            featureVersion = StringUtils.isNotBlank((String)buildNumber) ? featureVersion + "-build" + buildNumber : featureVersion + "-SNAPSHOT";
            this.pomUpdater.removeSnapshotFromFeatureVersions(ProjectCacheKey.FEATURE_DEPLOY_LABEL, featureVersion, reactorProjects);
            MavenProject rootProject = ReleaseUtil.getRootProject(featureProjects);
            featureSession = this.mavenExecutionHelper.reloadReactor(rootProject, session);
            rootProject = ReleaseUtil.getRootProject((List)featureSession.getSortedProjects());
            if (!ctx.isNoBuild()) {
                String mvnGoals = "clean install deploy";
                if (StringUtils.isNotBlank((String)goals)) {
                    mvnGoals = goals;
                }
                try {
                    for (String goal : Splitter.on((String)" ").trimResults().omitEmptyStrings().split((CharSequence)mvnGoals)) {
                        this.mavenExecutionHelper.execute(rootProject, featureSession, goal);
                    }
                }
                catch (MavenExecutorException e) {
                    throw new MavenJGitFlowException("Error building: " + e.getMessage(), e);
                }
            }
            flow.git().reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error finish feature: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new MavenJGitFlowException("Error finish feature: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new MavenJGitFlowException("Error finish feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                JGitFlowReporter.get().flush();
            }
        }
    }

    public String getStartLabelAndRunPreflight(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowException, MavenJGitFlowException {
        this.runPreflight(ctx, reactorProjects, session);
        JGitFlow flow = this.jGitFlowProvider.gitFlow();
        List<MavenProject> branchProjects = this.checkoutAndGetProjects.run(flow.getDevelopBranchName()).getProjects();
        this.verifyInitialVersionState.run(BranchType.FEATURE, branchProjects);
        return this.labelProvider.getFeatureStartName();
    }

    public String getFinishLabelAndRunPreflight(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowException, MavenJGitFlowException {
        this.runPreflight(ctx, reactorProjects, session);
        return this.labelProvider.getFeatureFinishName();
    }
}

