/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.temperature;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.util.Objects;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditor;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorConfig;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorModel;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

public class TemperatureEditorHandler
extends BeanUIHandlerSupport<TemperatureEditor>
implements UIHandler<TemperatureEditor> {
    private static final Logger log = LogManager.getLogger(TemperatureEditorHandler.class);

    @Override
    public void beforeInit(TemperatureEditor ui) {
        super.beforeInit(ui);
        TemperatureEditorModel model = new TemperatureEditorModel();
        model.setFormat(TemperatureFormat.C);
        ui.setContextValue(model);
    }

    @Override
    protected String getProperty(TemperatureEditor ui) {
        TemperatureEditorModel model = ui.getModel();
        if (model == null) {
            return null;
        }
        TemperatureEditorConfig config = model.getConfig();
        if (config == null) {
            return null;
        }
        return config.getProperty();
    }

    public void init(TemperatureEditor ui, JLabel label) {
        Objects.requireNonNull(label, "No label, can't init.");
        this.init(ui);
        TemperatureEditorModel model = ui.getModel();
        model.addPropertyChangeListener("format", evt -> label.setText(model.getLabel()));
        label.setText(model.getLabel());
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init TemperatureEditor", ((TemperatureEditor)this.ui).getName()));
        TemperatureEditorModel model = ((TemperatureEditor)this.ui).getModel();
        TemperatureEditorConfig config = model.getConfig();
        Objects.requireNonNull(config, "No config in editor, can't init.");
        if (property == null || property.isEmpty()) {
            config.setProperty(((TemperatureEditor)this.ui).getName());
        }
        ((TemperatureEditor)this.ui).getEditor().init();
        ((TemperatureEditor)this.ui).getEditor().getModel().addPropertyChangeListener("numberValue", evt -> model.setTemperature((Float)evt.getNewValue()));
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        TemperatureEditorModel model = ((TemperatureEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Float newValue;
            Float oldValue = model.getTemperature();
            if (!Objects.equals(oldValue, newValue = (Float)e.getNewValue())) {
                log.debug(String.format("%s - [%s] get new value from bean: %s", ((TemperatureEditor)this.ui).getName(), property, newValue));
                ((TemperatureEditor)this.ui).setStorageTemperature(newValue);
            }
        });
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        TemperatureEditorModel model = ((TemperatureEditor)this.ui).getModel();
        model.addPropertyChangeListener("storageTemperature", evt -> {
            Object newValue = evt.getNewValue();
            if (!Objects.equals(newValue, bean.get(property))) {
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((TemperatureEditor)this.ui).getName(), property, newValue));
                bean.set(property, newValue);
            }
        });
    }
}

