/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.status;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.status.StatusMessagePanel;

public class StatusMessagePanelHandler
implements UIHandler<StatusMessagePanel> {
    protected StatusMessagePanel ui;
    protected Color statusForeground;
    protected String statusReferenceContent;
    protected Timer timer;

    public void init() {
        if (this.ui.isShowBusy().booleanValue()) {
            Dimension dim = new Dimension(30, 15);
            JProgressBar busyWidget = this.ui.getBusyWidget();
            busyWidget.setMaximumSize(dim);
            busyWidget.setMinimumSize(dim);
            this.ui.addPropertyChangeListener("busy", evt -> {
                Boolean newValue = (Boolean)evt.getNewValue();
                busyWidget.setEnabled(newValue);
                busyWidget.setIndeterminate(newValue);
            });
        }
    }

    public void clearStatus() {
        this.stopStatusFader(this.ui);
        this.ui.getStatusLabel().setText(" ");
    }

    public void setStatus(String status) {
        if (status != null) {
            this.stopStatusFader(this.ui);
            this.ui.getStatusLabel().setText(status);
        }
        if (!this.ui.isBusy().booleanValue() && this.ui.isShowing()) {
            this.startStatusFader(this.ui);
        }
    }

    protected void fadeStatus(StatusMessagePanel ui) {
        for (int i = 0; i < 8; ++i) {
            if (!this.statusReferenceContent.equals(ui.getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = ui.getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(), currentForeground.getGreen(), currentForeground.getBlue(), currentForeground.getAlpha() - 25);
            ui.getStatusLabel().setForeground(newColor);
            ui.getStatusLabel().repaint();
        }
    }

    protected void startStatusFader(StatusMessagePanel ui) {
        if (!ui.isVisible() && !ui.isShowing()) {
            return;
        }
        this.statusReferenceContent = ui.getStatusLabel().getText();
        int millisecondsPerMinute = 5000;
        if (this.timer == null) {
            this.timer = new Timer(millisecondsPerMinute, ui);
            this.timer.setRepeats(false);
            this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
        }
        this.timer.start();
    }

    protected void stopStatusFader(StatusMessagePanel ui) {
        if (this.timer != null) {
            this.timer.stop();
            ui.getStatusLabel().setForeground(this.statusForeground);
        }
    }

    public void beforeInit(StatusMessagePanel ui) {
        this.ui = ui;
    }
}

