/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.number;

import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.number.NumberEditorConfig;

public class NumberEditorModel
extends AbstractSerializableBean
implements ModelToBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_TEXT_VALUE = "textValue";
    public static final String PROPERTY_NUMBER_VALUE = "numberValue";
    public static final String PROPERTY_NUMBER_PATTERN = "numberPattern";
    private final NumberEditorConfig config;
    protected Object bean;
    protected String textValue;
    protected Number numberValue;
    protected String numberPattern;
    protected boolean textValueIsAdjusting;
    protected boolean numberValueIsAdjusting;

    public NumberEditorModel(NumberEditorConfig config) {
        this.config = config;
    }

    public NumberEditorConfig getConfig() {
        return this.config;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Object oldValue = this.getBean();
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        String oldValue = this.getNumberPattern();
        this.numberPattern = numberPattern;
        this.firePropertyChange(PROPERTY_NUMBER_PATTERN, oldValue, numberPattern);
    }

    public Number getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(Number numberValue) {
        if (!this.numberValueIsAdjusting) {
            this.numberValueIsAdjusting = true;
            try {
                Number oldValue = this.getNumberValue();
                this.numberValue = numberValue;
                this.firePropertyChange(PROPERTY_NUMBER_VALUE, oldValue, numberValue);
            }
            finally {
                this.numberValueIsAdjusting = false;
            }
        }
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (!this.textValueIsAdjusting) {
            this.textValueIsAdjusting = true;
            try {
                String oldValue = this.getTextValue();
                this.textValue = textValue;
                this.firePropertyChange(PROPERTY_TEXT_VALUE, oldValue, textValue);
                this.firePropertyChange("canUseDot", null, this.isCanUseDot());
                this.firePropertyChange("canUseSign", null, this.isCanUseSign());
                this.firePropertyChange("canUseZero", null, this.isCanUseZero());
                this.firePropertyChange("canClearAll", null, this.isCanClearAll());
            }
            finally {
                this.textValueIsAdjusting = false;
            }
        }
    }

    public boolean isCanUseDot() {
        Boolean useDecimal = this.config.getUseDecimal();
        return useDecimal != null && useDecimal != false && !this.textValue.contains(".");
    }

    public boolean isCanUseSign() {
        return this.config.isUseSign() && StringUtils.isNotBlank((CharSequence)this.textValue);
    }

    public boolean isCanUseZero() {
        return StringUtils.isNotBlank((CharSequence)this.textValue) && "0".equals(this.textValue);
    }

    public boolean isCanClearAll() {
        return StringUtils.isNotBlank((CharSequence)this.textValue);
    }

    public boolean isTextValueIsAdjusting() {
        return this.textValueIsAdjusting;
    }

    public boolean isNumberValueIsAdjusting() {
        return this.numberValueIsAdjusting;
    }

    protected Predicate<NumberEditorModel> canUpdateBeanNumberValuePredicate() {
        return input -> true;
    }
}

