/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.InputMap;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditorModel;
import org.nuiton.jaxx.widgets.datetime.ExtendedBasicDatePickerUI;
import org.nuiton.jaxx.widgets.datetime.TimeSliderInitializer;

public class DateTimeEditorHandler
extends BeanUIHandlerSupport<DateTimeEditor>
implements UIHandler<DateTimeEditor> {
    private static final Logger log = LogManager.getLogger(DateTimeEditorHandler.class);
    protected final Calendar calendarMinute = new GregorianCalendar();
    protected final Calendar calendarHour = new GregorianCalendar();

    @Override
    public void beforeInit(DateTimeEditor ui) {
        super.beforeInit(ui);
        DateTimeEditorModel model = new DateTimeEditorModel();
        ui.setContextValue(model);
    }

    public void afterInit(DateTimeEditor ui) {
        ui.getMinuteEditor().setEditor(new JSpinner.DateEditor(ui.getMinuteEditor(), "mm"));
        ui.getHourEditor().setEditor(new JSpinner.DateEditor(ui.getHourEditor(), "HH"));
        JSlider slider = ui.getSlider();
        TimeSliderInitializer timeSliderInitializer = new TimeSliderInitializer();
        timeSliderInitializer.init(slider);
        ExtendedBasicDatePickerUI extendedUi = new ExtendedBasicDatePickerUI();
        extendedUi.setShowPopupButton(true);
        JXDatePicker dateEditor = ui.getDayDateEditor();
        dateEditor.setUI((DatePickerUI)extendedUi);
        InputMap pickerInputMap = dateEditor.getInputMap(1);
        pickerInputMap.put(KeyStroke.getKeyStroke("pressed DOWN"), "TOGGLE_POPUP");
        dateEditor.getEditor().setFocusLostBehavior(0);
    }

    @Override
    protected String getProperty(DateTimeEditor ui) {
        return ui.getModel().getPropertyDate();
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init DateTimeEditor", ((DateTimeEditor)this.ui).getName()));
        if (property == null || property.isEmpty()) {
            ((DateTimeEditor)this.ui).setPropertyDate(((DateTimeEditor)this.ui).getName());
        }
        DateTimeEditorModel model = ((DateTimeEditor)this.ui).getModel();
        model.addPropertyChangeListener("date", evt -> {
            if (model.isDateEditable()) {
                model.setTimeEditable(evt.getNewValue() != null);
            }
        });
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        DateTimeEditorModel model = ((DateTimeEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Date newValue;
            Date oldValue = model.getDate();
            if (!Objects.equals(oldValue, newValue = (Date)e.getNewValue())) {
                ((DateTimeEditor)this.ui).setDate(newValue);
            }
        });
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        String propertyTimeDate;
        DateTimeEditorModel model = ((DateTimeEditor)this.ui).getModel();
        Predicate<DateTimeEditorModel> predicate = model.canUpdateBeanValuePredicate();
        model.addPropertyChangeListener("date", evt -> {
            if (predicate.test(model)) {
                Object newValue = evt.getNewValue();
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((DateTimeEditor)this.ui).getName(), property, newValue));
                bean.set(property, newValue);
            }
        });
        String propertyDayDate = model.getPropertyDayDate();
        if (propertyDayDate != null) {
            model.addPropertyChangeListener("dayDate", evt -> {
                if (predicate.test(model)) {
                    bean.set(propertyDayDate, evt.getNewValue());
                }
            });
        }
        if ((propertyTimeDate = model.getPropertyTimeDate()) != null) {
            model.addPropertyChangeListener("timeDate", evt -> {
                if (predicate.test(model)) {
                    bean.set(propertyTimeDate, evt.getNewValue());
                }
            });
        }
    }

    public Date getMinuteModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = ((DateTimeEditor)this.ui).getModel().getDate() == null ? new Date(0L) : new Date();
        }
        this.calendarMinute.setTime(incomingDate);
        this.calendarMinute.set(11, 0);
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public Date getHourModelValue(Date incomingDate) {
        boolean dateIsNull;
        boolean bl = dateIsNull = incomingDate == null && ((DateTimeEditor)this.ui).getModel().getDate() == null;
        if (incomingDate == null) {
            incomingDate = dateIsNull ? new Date(0L) : new Date();
        }
        this.calendarHour.setTime(incomingDate);
        this.calendarHour.set(12, 0);
        if (dateIsNull) {
            this.calendarHour.set(11, 0);
        }
        incomingDate = this.calendarHour.getTime();
        return incomingDate;
    }

    public void setHours(Date hourDate) {
        int oldMinute;
        DateTimeEditorModel model = ((DateTimeEditor)this.ui).getModel();
        Date oldTimeDate = model.getTimeDate();
        boolean oldTimeNull = oldTimeDate == null;
        this.calendarHour.setTime(hourDate);
        int newHour = this.calendarHour.get(11);
        int newMinute = this.calendarHour.get(12);
        int oldHour = oldTimeNull ? -1 : model.getHour(oldTimeDate);
        int n = oldMinute = oldTimeNull ? -1 : model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            log.debug(String.format("Do not update time model , stay on same time = %d:%d", oldHour, oldMinute));
            return;
        }
        log.debug(String.format("hh:mm (old from dateModel)   = %d:%d", oldHour, oldMinute));
        log.debug(String.format("hh:mm (new from hourModel) = %d:%d", newHour, newMinute));
        if (!oldTimeNull) {
            Integer dayAdjust = null;
            if (newHour == 0 && oldHour == 23) {
                dayAdjust = 1;
            } else if (newHour == 23 && oldHour == 0) {
                dayAdjust = -1;
            }
            if (dayAdjust != null) {
                Date oldDayDate = model.getDayDate();
                this.calendarHour.setTime(oldDayDate);
                this.calendarHour.add(6, dayAdjust);
                log.debug(String.format("Update day to %d", this.calendarHour.get(6)));
                Date newDayDate = this.calendarHour.getTime();
                model.setDayDate(newDayDate);
            }
        }
        model.setTimeInMinutes(newHour * 60 + oldMinute);
    }

    public void setMinutes(Date minuteDate) {
        int oldMinute;
        DateTimeEditorModel model = ((DateTimeEditor)this.ui).getModel();
        Date oldTimeDate = model.getTimeDate();
        boolean oldTimeNull = oldTimeDate == null;
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = oldTimeNull ? -1 : model.getHour(oldTimeDate);
        int n = oldMinute = oldTimeNull ? -1 : model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            log.debug(String.format("Do not update time model , stay on same time = %d:%d", oldHour, oldMinute));
            return;
        }
        int hour = oldHour == -1 ? 0 : oldHour;
        log.debug(String.format("hh:mm (old from dateModel)   = %d:%d", oldHour, oldMinute));
        log.debug(String.format("hh:mm (new from minuteModel) = %d:%d", newHour, newMinute));
        if (!oldTimeNull) {
            Integer dayAdjust = null;
            if (newMinute == 0) {
                if (newHour == 1) {
                    if (oldHour == 23) {
                        dayAdjust = 1;
                    }
                    hour = (oldHour + 1) % 24;
                }
            } else if (newMinute == 59 && newHour == 23) {
                if (oldHour == 0) {
                    dayAdjust = -1;
                }
                hour = (oldHour - 1) % 24;
            }
            if (dayAdjust != null) {
                Date oldDayDate = model.getDayDate();
                this.calendarHour.setTime(oldDayDate);
                this.calendarHour.add(6, dayAdjust);
                log.debug(String.format("Update day to %d", this.calendarHour.get(6)));
                Date newDayDate = this.calendarHour.getTime();
                model.setDayDate(newDayDate);
            }
        }
        log.debug(String.format("Update time model to hh:mm = %d:%d", hour, newMinute));
        model.setTimeInMinutes(hour * 60 + newMinute);
    }
}

