/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Predicate;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.runtime.util.DateUtil;
import org.nuiton.jaxx.widgets.ModelToBean;

public class DateEditorModel
extends AbstractSerializableBean
implements ModelToBean {
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_VALUE_IS_ADJUSTING = "valueIsAdjusting";
    private static final long serialVersionUID = 1L;
    protected final boolean fillState = true;
    protected final Calendar calendar = new GregorianCalendar();
    protected Object bean;
    protected String property;
    protected boolean editable = true;
    protected Date date;
    protected boolean valueIsAdjusting;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        Preconditions.checkState((boolean)true, (Object)"cant change *property* property once the fillState is off.");
        this.property = property;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Preconditions.checkState((boolean)true, (Object)"cant change *bean* property once the fillState is off.");
        this.bean = bean;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, null, editable);
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        boolean oldValue = this.isValueIsAdjusting();
        this.valueIsAdjusting = valueIsAdjusting;
        this.fireValueIsAdjusting(oldValue);
    }

    void reset() {
        Date oldDate = this.date;
        this.setValueIsAdjusting(true);
        try {
            this.date = this.isEditable() ? null : this.getDate();
            this.fireDate(oldDate);
        }
        finally {
            this.setValueIsAdjusting(false);
        }
        this.fireDate(oldDate);
    }

    public Date getDate() {
        return this.date == null ? null : DateUtil.getDay((Date)this.date);
    }

    public void setDate(Date date) {
        Date oldValue = this.getDate();
        if (Objects.equals(date, oldValue)) {
            return;
        }
        this.date = date == null ? null : DateUtil.getDay((Date)date);
        this.fireDate(oldValue);
    }

    protected void fireDate(Date oldDate) {
        this.firePropertyChange(PROPERTY_DATE, oldDate, this.getDate());
    }

    protected void fireValueIsAdjusting(boolean oldValue) {
        this.firePropertyChange(PROPERTY_VALUE_IS_ADJUSTING, oldValue, this.isValueIsAdjusting());
    }

    protected Predicate<DateEditorModel> canUpdateBeanValuePredicate() {
        return input -> !this.isValueIsAdjusting();
    }
}

