/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.datetime.DateEditor;
import org.nuiton.jaxx.widgets.datetime.DateEditorModel;
import org.nuiton.jaxx.widgets.datetime.ExtendedBasicDatePickerUI;

public class DateEditorHandler
extends BeanUIHandlerSupport<DateEditor>
implements UIHandler<DateEditor> {
    private static final Logger log = LogManager.getLogger(DateEditorHandler.class);

    @Override
    public void beforeInit(DateEditor ui) {
        super.beforeInit(ui);
        DateEditorModel model = new DateEditorModel();
        ui.setContextValue(model);
    }

    public void afterInit(DateEditor ui) {
        ExtendedBasicDatePickerUI extendedUi = new ExtendedBasicDatePickerUI();
        extendedUi.setShowPopupButton(true);
        ui.getDateEditor().setUI((DatePickerUI)extendedUi);
        JXDatePicker dateEditor = ui.getDateEditor();
        InputMap pickerInputMap = dateEditor.getInputMap(1);
        pickerInputMap.put(KeyStroke.getKeyStroke("pressed DOWN"), "TOGGLE_POPUP");
        dateEditor.getEditor().setFocusLostBehavior(0);
    }

    @Override
    protected String getProperty(DateEditor ui) {
        return ui.getModel().getProperty();
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init DateEditor", ((DateEditor)this.ui).getName()));
        if (property == null || property.isEmpty()) {
            ((DateEditor)this.ui).setProperty(((DateEditor)this.ui).getName());
        }
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        DateEditorModel model = ((DateEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Date newValue;
            Date oldValue = model.getDate();
            if (!Objects.equals(oldValue, newValue = (Date)e.getNewValue())) {
                ((DateEditor)this.ui).setDate(newValue);
            }
        });
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        DateEditorModel model = ((DateEditor)this.ui).getModel();
        Predicate<DateEditorModel> predicate = model.canUpdateBeanValuePredicate();
        model.addPropertyChangeListener("date", evt -> {
            if (predicate.test(model)) {
                Object newValue = evt.getNewValue();
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((DateEditor)this.ui).getName(), property, newValue));
                bean.set(property, newValue);
            }
        });
    }
}

