/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.list;

import io.ultreia.java4all.decoration.Decorated;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.BeanUIUtil;
import io.ultreia.java4all.jaxx.widgets.list.ListHeader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;

public class ListHeaderHandler<O>
implements PropertyChangeListener,
UIHandler<ListHeader<O>> {
    public static final Logger log = LogManager.getLogger(ListHeaderHandler.class);
    protected ListHeader<O> ui;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return ListHeaderHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return ListHeaderHandler.this.ui.getChangeDecorator();
        }
    };
    protected Decorator decorator;
    protected boolean init;

    public void init(Decorator decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.ui.removeDataBinding("resetSelection.enabled");
        this.ui.applyDataBinding("resetSelection.enabled");
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.decorator = decorator.copy();
        this.ui.getList().setCellRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(this.decorator));
        this.popupHandler.preparePopup(this.ui.getSelectedToolTipText(), this.ui.getNotSelectedToolTipText(), this.ui.getI18nPrefix(), this.ui.getPopupTitleText(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUI(int index, boolean reverseSort) {
        this.decorator.setIndex(index);
        List<O> selection = this.ui.getList().getSelectedValuesList();
        List<O> datas = this.ui.getData();
        try {
            this.decorator.sort(datas, index, reverseSort);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.ui.getList().setValueIsAdjusting(true);
        try {
            ListModel<O> listModel = this.ui.getList().getModel();
            if (listModel instanceof DefaultListModel) {
                DefaultListModel model = (DefaultListModel)listModel;
                model.removeAllElements();
                for (O data : datas) {
                    model.addElement(data);
                }
            } else {
                this.ui.getList().setListData(new Vector<O>(datas));
            }
            if (selection.size() > 0) {
                ArrayIntList newSelection = new ArrayIntList();
                for (O o : selection) {
                    if (!datas.contains(o)) continue;
                    newSelection.add(datas.indexOf(o));
                }
                if (!newSelection.isEmpty()) {
                    int[] ints = newSelection.toArray(new int[newSelection.size()]);
                    newSelection.clear();
                    this.ui.getList().setSelectedIndices(ints);
                }
            }
        }
        finally {
            this.ui.getList().setValueIsAdjusting(false);
            this.ui.getList().repaint();
        }
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            if (this.decorator != null && this.ui.getData() != null) {
                this.ui.getData().forEach(datum -> ((Decorated)datum).registerDecorator(this.decorator));
            }
            this.setIndex(-1, this.ui.getIndex());
        }
    }

    public O getSelectedValue() {
        JList<O> list = this.ui.getList();
        return list == null ? null : (O)list.getSelectedValue();
    }

    public void beforeInit(ListHeader<O> ui) {
        this.ui = ui;
    }

    public void afterInit(ListHeader<O> ui) {
    }
}

