/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.list;

import io.ultreia.java4all.decoration.Decorated;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.BeanUIUtil;
import io.ultreia.java4all.jaxx.widgets.list.DoubleList;
import io.ultreia.java4all.jaxx.widgets.list.DoubleListConfig;
import io.ultreia.java4all.jaxx.widgets.list.DoubleListModel;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListRemoveAction;
import io.ultreia.java4all.lang.Setters;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableListModel;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.jaxx.runtime.swing.renderer.FilteredDecoratorListCellRenderer;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;

public class DoubleListHandler<O>
implements UIHandler<DoubleList<O>> {
    private static final Logger log = LogManager.getLogger(DoubleListHandler.class);
    private DoubleList<O> ui;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return DoubleListHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return DoubleListHandler.this.ui.getDisplayDecorator();
        }
    };
    private Decorator decorator;

    public void beforeInit(DoubleList<O> ui) {
        this.ui = ui;
        DoubleListConfig config = new DoubleListConfig();
        DoubleListModel model = new DoubleListModel(config);
        ui.setContextValue(model);
    }

    public void afterInit(DoubleList<O> ui) {
        DoubleListRemoveAction.init(ui, (AbstractButton)ui.getSelectedListRemoveAction(), new DoubleListRemoveAction());
        SwingUtil.changeFontSize((JComponent)ui.getAddAction(), (float)10.0f);
        SwingUtil.changeFontSize((JComponent)ui.getRemoveAction(), (float)10.0f);
    }

    public void addFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().addFilter(filter);
    }

    public void removeFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().removeFilter(filter);
    }

    public void clearFilters() {
        this.ui.getModel().getUniverseModel().clearFilters();
    }

    public void refreshFilteredElements() {
        this.ui.getModel().getUniverseModel().refreshFilteredElements();
    }

    public void onUniverseListClicked(MouseEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            Object item = this.ui.getModel().getUniverseModel().getElementAt(index);
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(item);
            this.addToSelected(items);
        }
    }

    public void onUniverseListFocusGained(FocusEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> list = this.ui.getUniverseList();
        if (list.isSelectionEmpty() && list.getModel().getSize() > 0) {
            list.setSelectedIndex(0);
        }
    }

    public void addToSelected(List<O> items) {
        this.ui.getModel().addToSelected(items);
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    public void removeFromSelected(List<O> items) {
        this.ui.getModel().removeFromSelected(items);
        this.sortData();
    }

    public void onSelectedListClicked(MouseEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(this.ui.getModel().getSelectedModel().getElementAt(index));
            this.removeFromSelected(items);
        }
    }

    public void onSelectedListFocusGained(FocusEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> list = this.ui.getSelectedList();
        if (list.isSelectionEmpty() && list.getModel().getSize() > 0) {
            list.setSelectedIndex(0);
        }
    }

    public void onKeyPressedOnUniverseList(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int lastIndice = this.ui.getUniverseList().getSelectionModel().getLeadSelectionIndex();
            this.ui.getAddAction().doClick();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            }
        }
    }

    public void onKeyPressedOnSelectedList(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int lastIndice = this.ui.getSelectedList().getSelectionModel().getLeadSelectionIndex();
            this.ui.getRemoveAction().doClick();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            }
        }
    }

    public void selectFirstRowIfNoSelection(FocusEvent e) {
        JList source = (JList)e.getSource();
        if (source.isSelectionEmpty()) {
            source.setSelectedIndex(0);
        }
    }

    public JPopupMenu getSelectedListPopup(boolean showIt) {
        JPopupMenu result = showIt ? this.ui.getSelectedListPopup() : null;
        return result;
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void init(Decorator decorator, List<O> universe, List<O> selected) {
        String property;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.decorator = decorator.copy();
        DoubleListModel<O> model = this.ui.getModel();
        this.ui.addPropertyChangeListener("enabled", e -> {
            boolean newValue = (Boolean)e.getNewValue();
            if (!newValue) {
                this.ui.getUniverseList().getSelectionModel().clearSelection();
                this.ui.getSelectedList().getSelectionModel().clearSelection();
            }
        });
        DoubleListConfig<O> config = model.getConfig();
        Object bean = model.getBean();
        if (bean != null && (property = config.getProperty()) != null) {
            Method mutator = Setters.getMutator(bean, property);
            Objects.requireNonNull(mutator, "could not find mutator for " + property);
            model.addPropertyChangeListener("selected", new MutateOnConditionalPropertyChangeListener<DoubleListModel>(model, mutator, DoubleListModel2 -> true));
        }
        if (config.isShowListLabel()) {
            this.ui.getUniverseHeaderLabel().setText(config.getUniverseLabel());
            this.ui.getSelectedHeaderLabel().setText(config.getSelectedLabel());
            JLabel label = new JLabel(config.getLabel());
            this.ui.getBeforeFilterPanel().add(label);
        }
        JList<O> universeList = this.ui.getUniverseList();
        final FilteredDecoratorListCellRenderer universeListCellRenderer = new FilteredDecoratorListCellRenderer(this.decorator);
        universeList.setCellRenderer((ListCellRenderer<O>)universeListCellRenderer);
        universeList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            this.ui.getModel().setAddEnabled(!source.isSelectionEmpty());
        });
        final JaxxFilterableListModel<O> filterModel = this.ui.getModel().getUniverseModel();
        filterModel.setDecorator(this.decorator);
        this.ui.getFilterField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = DoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = DoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String text = DoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }
        });
        JList<O> selectedList = this.ui.getSelectedList();
        selectedList.setCellRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(this.decorator));
        selectedList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            DoubleListModel<O> model1 = this.ui.getModel();
            if (!e.getValueIsAdjusting()) {
                boolean removeEnabled = !source.isSelectionEmpty();
                model1.setRemoveEnabled(removeEnabled);
                int minSelectionIndex = source.getMinSelectionIndex();
                int maxSelectionIndex = source.getMaxSelectionIndex();
                boolean oneSelection = minSelectionIndex == maxSelectionIndex;
                boolean upEnabled = removeEnabled && oneSelection && minSelectionIndex > 0;
                model1.setSelectedUpEnabled(upEnabled);
                boolean downEnabled = removeEnabled && oneSelection && minSelectionIndex + 1 < model1.getSelectedListSize();
                model1.setSelectedDownEnabled(downEnabled);
            }
        });
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.popupHandler.preparePopup(null, null, config.getI18nPrefix(), config.getLabel(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        indexes.setSelectedButton((Object)this.ui.getIndex());
        this.setUniverse(universe);
        this.setSelected(selected);
        this.ui.addPropertyChangeListener("index", evt -> this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue()));
        this.ui.addPropertyChangeListener("reverseSort", evt -> this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue()));
        this.ui.addPropertyChangeListener("highlightFilterText", evt -> this.setHighlightFilterText((Boolean)evt.getNewValue()));
        this.ui.processDataBinding("selectedList.componentPopupMenu");
    }

    protected void setSelected(List<O> selected) {
        DoubleListModel<O> model = this.ui.getModel();
        if (selected != null && this.decorator != null) {
            selected.forEach(datum -> ((Decorated)datum).registerDecorator(this.decorator));
        }
        model.setSelected(selected);
        if (model.getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        log.debug("check state : <" + oldValue + " to " + newValue + ">");
        this.updateUI(this.ui.getIndex(), newValue);
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    protected void setHighlightFilterText(Boolean newValue) {
        FilteredDecoratorListCellRenderer universeListCellRenderer = (FilteredDecoratorListCellRenderer)this.ui.getUniverseList().getCellRenderer();
        universeListCellRenderer.setHighlightFilterText(newValue.booleanValue());
        this.ui.getUniverseList().repaint();
    }

    protected void updateUI(int index, boolean reverseSort) {
        if (this.decorator == null) {
            return;
        }
        this.decorator.setIndex(index);
        List data = this.ui.getModel().getUniverseModel().toList();
        try {
            this.decorator.sort(data, index, reverseSort);
        }
        catch (Exception eee) {
            log.warn(eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getUniverseList(), (Collection)data, null);
    }

    protected void sortSelectedList() {
        if (this.decorator == null) {
            return;
        }
        List data = this.ui.getModel().getSelectedModel().toList();
        try {
            this.decorator.sort(data, this.ui.getIndex().intValue(), this.ui.isReverseSort().booleanValue());
        }
        catch (Exception eee) {
            log.warn(eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getSelectedList(), (Collection)data, null);
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setUniverse(List<O> universe) {
        if (this.decorator != null) {
            universe.forEach(datum -> ((Decorated)datum).registerDecorator(this.decorator));
        }
        DoubleListModel<O> model = this.ui.getModel();
        this.sort(universe);
        model.setUniverse(universe);
    }

    public void sort(List<O> data) {
        Decorator decorator = this.ui.getModel().getUniverseModel().getDecorator();
        Integer index = this.ui.getIndex();
        Boolean reverseSort = this.ui.isReverseSort();
        decorator.sort(data, index.intValue(), reverseSort.booleanValue());
    }
}

