/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.length.nautical;

import io.ultreia.java4all.bean.AbstractJavaBean;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorConfig;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormat;

public class NauticalLengthEditorModel
extends AbstractJavaBean {
    public static final String PROPERTY_FORMAT = "format";
    static final String PROPERTY_STORAGE_NAUTICAL_LENGTH = "storageNauticalLength";
    static final String PROPERTY_NAUTICAL_LENGTH = "nauticalLength";
    private NauticalLengthEditorConfig config;
    private NauticalLengthFormat format;
    private Float nauticalLength;
    private Float storageNauticalLength;
    private Object bean;
    private boolean adjusting;

    public NauticalLengthEditorConfig getConfig() {
        return this.config;
    }

    public void setConfig(NauticalLengthEditorConfig config) {
        this.config = config;
    }

    public String getLabel() {
        return this.config.getLabel() + " (" + this.format.getLabel() + ")";
    }

    public NauticalLengthFormat getFormat() {
        return this.format;
    }

    public void setFormat(NauticalLengthFormat format) {
        NauticalLengthFormat oldValue = this.getFormat();
        this.format = format;
        this.firePropertyChange(PROPERTY_FORMAT, (Object)oldValue, (Object)format);
        this.adjusting = true;
        try {
            this.setStorageNauticalLength(this.storageNauticalLength);
        }
        finally {
            this.adjusting = false;
        }
    }

    public Float getNauticalLength() {
        return this.nauticalLength;
    }

    public void setNauticalLength(Float nauticalLength) {
        Float oldNauticalLength = this.getNauticalLength();
        this.nauticalLength = nauticalLength;
        this.firePropertyChange(PROPERTY_NAUTICAL_LENGTH, oldNauticalLength, nauticalLength);
        if (!this.adjusting) {
            Float oldStorageNauticalLength = this.getStorageNauticalLength();
            this.storageNauticalLength = this.format.convert(this.config.getStorageFormat(), nauticalLength);
            this.firePropertyChange(PROPERTY_STORAGE_NAUTICAL_LENGTH, oldStorageNauticalLength, this.storageNauticalLength);
        }
    }

    public Float getStorageNauticalLength() {
        return this.storageNauticalLength;
    }

    void setStorageNauticalLength(Float storageNauticalLength) {
        this.storageNauticalLength = storageNauticalLength;
        if (this.config != null) {
            Float oldNauticalLength = this.getNauticalLength();
            this.nauticalLength = this.config.getStorageFormat().convert(this.format, storageNauticalLength);
            this.firePropertyChange(PROPERTY_NAUTICAL_LENGTH, oldNauticalLength, this.nauticalLength);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}

