/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.decoration.Decorated;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.BeanUIUtil;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxBasicComboBoxUI;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBox;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxConfig;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxEditor;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class JaxxComboBoxHandler<O extends JavaBean>
implements PropertyChangeListener,
UIHandler<JaxxComboBox<O>> {
    public static final Logger log = LogManager.getLogger(JaxxComboBoxHandler.class);
    protected JaxxComboBox<O> ui;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return JaxxComboBoxHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return JaxxComboBoxHandler.this.ui.getDisplayDecorator();
        }
    };
    protected boolean init;
    private JaxxComboBoxEditor<O> editor;
    private JList<O> jList;
    private int selectedIndex;
    private JComboBox<O> combobox;
    private JaxxComboBoxModel<O> model;
    private JaxxComboBoxConfig<O> config;

    public void beforeInit(JaxxComboBox<O> ui) {
        this.ui = ui;
    }

    public void afterInit(JaxxComboBox<O> ui) {
        this.model = ui.getModel();
        this.config = this.model.getConfig();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedItem".equals(propertyName)) {
            this.setSelectedItem((JavaBean)this.ui.getBeanType().cast(evt.getOldValue()), (JavaBean)this.ui.getBeanType().cast(evt.getNewValue()));
            return;
        }
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(null, this.model.getIndex());
            List list = (List)evt.getOldValue();
            this.model.fireEmpty(list == null || list.isEmpty());
        }
    }

    public void init(Decorator decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        this.config.setDecorator(Objects.requireNonNull(decorator, String.format("decorator can not be null (for type %s)", this.ui.getBeanType())).copy());
        if (this.config.getBeanType() == null) {
            this.config.setBeanType(decorator.definition().type());
        }
        this.combobox = this.ui.getCombobox();
        this.combobox.setUI(new JaxxBasicComboBoxUI());
        this.jList = ((JaxxBasicComboBoxUI)this.combobox.getUI()).getListBox();
        this.jList.addListSelectionListener(e -> {
            this.selectedIndex = this.jList.getSelectedIndex();
            log.trace(String.format("%s - Selected index: %d - %s", this.ui.getName(), this.selectedIndex, this.jList.getSelectedValue()));
        });
        this.editor = new JaxxComboBoxEditor<O>(this.ui);
        this.combobox.setEditor(this.editor);
        this.popupHandler.preparePopup(this.config.getSelectedToolTipText(), this.config.getNotSelectedToolTipText(), this.config.getI18nPrefix(), this.config.getPopupTitleText(), (ButtonGroup)this.ui.getIndexes(), this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.config.getDecorator());
        this.model.addPropertyChangeListener(this);
        this.model.setData(data);
        this.ui.getIndexes().setSelectedButton((Object)this.model.getIndex());
    }

    int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void reset() {
        this.model.setSelectedItem(null);
        this.editor.resetFilter(true);
        if (this.combobox.isShowing()) {
            this.combobox.hidePopup();
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || Objects.equals(newValue, oldValue)) {
            return;
        }
        log.debug(String.format("%s \u2192 change index state : <%d to %d>", this.ui.getName(), oldValue, newValue));
        AbstractButton button = this.ui.getIndexes().getButton((Object)newValue);
        if (button != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.model.getReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || Objects.equals(newValue, oldValue)) {
            return;
        }
        log.debug(String.format("%s \u2192 change reverse sort state : <%s to %s>", this.ui.getName(), oldValue, newValue));
        this.updateUI(this.model.getIndex(), newValue);
    }

    protected void setSelectedItem(O oldValue, O newValue) {
        if (oldValue == null && newValue == null) {
            return;
        }
        if (!this.config.getBeanType().isInstance(newValue)) {
            newValue = null;
        }
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if (newValue != null) {
            if (this.config.isBeanDecoratorAware()) {
                ((Decorated)newValue).registerDecorator(this.config.getDecorator());
            }
            this.editor.resetFilter(false);
        }
        log.debug(String.format("%s \u2192 change selected item state <%s to %s>", this.ui.getName(), oldValue, newValue));
        this.model.mutateBeanProperty(newValue);
    }

    private void updateUI(int index, boolean reverseSort) {
        Decorator decorator = this.config.getDecorator();
        decorator.setIndex(index);
        O previousSelectedItem = this.model.getSelectedItem();
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.model.selectedItem = null;
        }
        List<O> data = this.model.getData();
        if (this.config.isBeanDecoratorAware()) {
            data.forEach(datum -> ((Decorated)datum).registerDecorator(decorator));
            if (previousSelectedItem != null) {
                ((Decorated)previousSelectedItem).registerDecorator(decorator);
            }
        }
        if (this.config.isSortable() && data != null && !data.isEmpty()) {
            try {
                decorator.sort(data, index, reverseSort);
            }
            catch (Exception eee) {
                log.warn(eee.getMessage(), (Throwable)eee);
            }
        }
        SwingUtil.fillComboBox(this.ui.getCombobox(), data, null);
        if (previousSelectedItem != null) {
            this.model.setSelectedItem(previousSelectedItem);
        }
    }
}

