/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBox;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxConfig;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxModel;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableComboBoxModel;

public class JaxxComboBoxEditor<O extends JavaBean>
implements ComboBoxEditor {
    private static final Logger log = LogManager.getLogger(JaxxComboBoxEditor.class);
    private final JaxxComboBox<O> ui;
    private final String logPrefix;
    private final ComboBoxEditor wrapped;
    private final JaxxComboBoxModel<O> model;
    private final JaxxFilterableComboBoxModel<O> comboBoxModel;
    private final JaxxComboBoxConfig<O> config;
    private final JComboBox<O> combobox;

    static <O> void updateFilter(String logPrefix, JComboBox<O> combobox, JaxxFilterableComboBoxModel<O> comboBoxModel, JTextComponent editorComponent, String text, String finalText) {
        boolean wasPopupVisible;
        boolean bl = wasPopupVisible = combobox.isShowing() && combobox.isPopupVisible();
        if (wasPopupVisible) {
            log.debug(String.format("%s hide popup before update filter '%s'", logPrefix, text));
            combobox.hidePopup();
        }
        log.debug(String.format("%s update filter '%s'", logPrefix, text));
        comboBoxModel.setFilterText(text);
        if (wasPopupVisible) {
            log.warn(String.format("%s show back popup after update filter '%s'", logPrefix, text));
            combobox.showPopup();
        }
        editorComponent.setText(finalText);
    }

    public JaxxComboBoxEditor(final JaxxComboBox<O> ui) {
        this.ui = Objects.requireNonNull(ui);
        this.logPrefix = ui.getName() + " \u2192";
        this.combobox = ui.getCombobox();
        this.model = ui.getModel();
        this.comboBoxModel = ui.getComboBoxModel();
        this.config = this.model.getConfig();
        Decorator decorator = Objects.requireNonNull(this.config.getDecorator());
        this.wrapped = Objects.requireNonNull(ui.getCombobox().getEditor());
        JTextComponent editorComponent = this.getEditorComponent();
        InputMap inputMap = editorComponent.getInputMap();
        ActionMap actionMap = editorComponent.getActionMap();
        if (this.config.isTabToSelect()) {
            editorComponent.setFocusTraversalKeysEnabled(false);
            inputMap.put(KeyStroke.getKeyStroke("pressed TAB"), "focusNext");
            actionMap.put("focusNext", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug(String.format("%s \u2192 focusNext", ui.getName()));
                    JaxxComboBoxEditor.this.autoSelect();
                    JaxxComboBoxEditor.this.combobox.hidePopup();
                    FocusTraversalPolicy focusTraversalPolicy = ui.getFocusCycleRootAncestor().getFocusTraversalPolicy();
                    Component focusComponent = focusTraversalPolicy.getComponentAfter(ui.getFocusCycleRootAncestor(), JaxxComboBoxEditor.this.combobox.getEditor().getEditorComponent());
                    JaxxComboBoxEditor.this.changeFocus(focusComponent);
                }
            });
            inputMap.put(KeyStroke.getKeyStroke("shift pressed TAB"), "focusPrevious");
            actionMap.put("focusPrevious", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug(String.format("%s \u2192 focusPrevious", ui.getName()));
                    JaxxComboBoxEditor.this.autoSelect();
                    JaxxComboBoxEditor.this.combobox.hidePopup();
                    FocusTraversalPolicy focusTraversalPolicy = ui.getFocusCycleRootAncestor().getFocusTraversalPolicy();
                    Component focusComponent = focusTraversalPolicy.getComponentBefore(ui.getFocusCycleRootAncestor(), JaxxComboBoxEditor.this.combobox.getEditor().getEditorComponent());
                    JaxxComboBoxEditor.this.changeFocus(focusComponent);
                }
            });
        }
        if (this.config.isEnterToSelectUniqueUniverse()) {
            KeyStroke enterKeyStroke = KeyStroke.getKeyStroke("pressed ENTER");
            Object oldEnterKey = inputMap.get(enterKeyStroke);
            inputMap.put(enterKeyStroke, "enter");
            final Action oldEnterAction = actionMap.get(oldEnterKey);
            actionMap.put("enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.debug(String.format("%s \u2192 enter pressed", ui.getName()));
                    if (JaxxComboBoxEditor.this.autoSelect()) {
                        JaxxComboBoxEditor.this.combobox.hidePopup();
                        return;
                    }
                    oldEnterAction.actionPerformed(e);
                }
            });
        }
        editorComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ui.isEnabled()) {
                    JaxxComboBoxEditor.this.combobox.showPopup();
                }
            }
        });
        editorComponent.addKeyListener(new DocumentKeyListener<O>(ui, editorComponent));
        if (!this.config.isBeanDecoratorAware()) {
            this.comboBoxModel.setDecorator(decorator);
        }
        this.combobox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.combobox.addItemListener(e -> {
            Object item1 = e.getItem();
            if (item1 instanceof String) {
                return;
            }
            JavaBean item = (JavaBean)e.getItem();
            if (e.getStateChange() == 1) {
                log.debug(String.format("itemStateChanged selected %s - %s", item, item != null ? item.getClass() : null));
                editorComponent.setForeground(null);
                this.model.setSelectedItem(item);
            } else {
                log.debug(String.format("itemStateChanged deselected %s - %s", item, item != null ? item.getClass() : null));
                editorComponent.setForeground(this.config.getInvalidComboEditorTextColor());
            }
        });
    }

    private void changeFocus(Component focusComponent) {
        if (focusComponent != null) {
            log.debug(String.format("%s \u2192 Change focus to %s", this.ui.getName(), focusComponent));
            SwingUtilities.invokeLater(focusComponent::requestFocusInWindow);
        }
    }

    private boolean autoSelect() {
        if (!this.combobox.isPopupVisible()) {
            return false;
        }
        if (this.combobox.getItemCount() > 0) {
            int selectedIndex = this.ui.getHandler().getSelectedIndex();
            if (selectedIndex != -1) {
                log.debug(String.format("%s \u2192 Auto-select with *TAB* or *Enter* key", this.ui.getName()));
                this.combobox.setSelectedIndex(selectedIndex);
                return true;
            }
            if (this.combobox.getItemCount() == 1) {
                log.debug(String.format("%s \u2192 Auto-select unique result with *TAB* or *Enter* key", this.ui.getName()));
                this.combobox.setSelectedIndex(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public JTextComponent getEditorComponent() {
        return (JTextComponent)this.wrapped.getEditorComponent();
    }

    @Override
    public Object getItem() {
        return this.wrapped.getItem();
    }

    @Override
    public void setItem(Object anObject) {
        this.wrapped.setItem(anObject);
    }

    @Override
    public void selectAll() {
        this.wrapped.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.wrapped.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.wrapped.removeActionListener(l);
    }

    public void resetFilter(boolean force) {
        JTextComponent editorComponent = this.getEditorComponent();
        String text = editorComponent.getText();
        log.info(String.format("%s \u2192 Remove filter text, selected value was set from text '%s'", this.ui.getName(), text));
        JaxxComboBoxEditor.updateFilter(this.logPrefix, this.combobox, this.comboBoxModel, editorComponent, "", force ? "" : text);
    }

    static class DocumentKeyListener<O extends JavaBean>
    extends KeyAdapter {
        private final JComboBox<O> combobox;
        private final JTextComponent editorComponent;
        private final JaxxComboBoxModel<O> model;
        private final JaxxFilterableComboBoxModel<O> comboBoxModel;
        private final boolean filterable;
        private final String logPrefix;
        Boolean doOpenPopup = null;

        DocumentKeyListener(JaxxComboBox<O> ui, JTextComponent editorComponent) {
            this.combobox = ui.getCombobox();
            this.logPrefix = ui.getName() + " \u2192";
            this.comboBoxModel = ui.getComboBoxModel();
            this.model = ui.getModel();
            this.editorComponent = editorComponent;
            this.filterable = ui.getConfig().isFilterable();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.doOpenPopup = false;
            if (e.getKeyChar() == '\n') {
                this.doOpenPopup = true;
            } else if (Character.isAlphabetic(e.getKeyChar()) || Character.isSpaceChar(e.getKeyChar())) {
                this.doOpenPopup = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (27 == e.getKeyCode()) {
                log.debug(String.format("%s ESC , hide popup", this.logPrefix));
                e.consume();
                this.combobox.hidePopup();
                return;
            }
            if (10 == e.getKeyCode() && this.combobox.isPopupVisible()) {
                log.debug(String.format("%s Enter, hide popup ", this.logPrefix));
                this.combobox.hidePopup();
                e.consume();
                return;
            }
            if (9 == e.getKeyCode()) {
                log.debug(String.format("%s Tab, consume event", this.logPrefix));
                return;
            }
            if (e.isActionKey() || e.isControlDown() || e.isShiftDown() || e.isAltDown() || e.isAltGraphDown()) {
                log.debug(String.format("%s Consume action key!!!!!", this.logPrefix));
                e.consume();
                return;
            }
            if (e.isConsumed()) {
                log.debug(String.format("%s Already consumed key!!!!!", this.logPrefix));
                return;
            }
            if (this.doOpenPopup != null && this.doOpenPopup.booleanValue() && !this.combobox.isPopupVisible()) {
                log.debug(String.format("%s Will show popup, key event: %s", this.logPrefix, e.paramString()));
                this.combobox.showPopup();
                this.doOpenPopup = null;
            }
            O selectedItem = this.model.getSelectedItem();
            String text = this.editorComponent.getText();
            String selectedItemString = this.comboBoxModel.decorateElement(selectedItem);
            if (selectedItem != null && !selectedItemString.equals(text)) {
                log.debug(String.format("%s Unselect previous selected item ('%s), since it does not match the text: '%s'", this.logPrefix, selectedItemString, text));
                this.model.selectedItem = null;
                selectedItem = null;
                this.model.mutateBeanProperty(null);
            }
            if (this.filterable && selectedItem == null) {
                log.debug(String.format("%s filterText: %s, keyEvent: '%s'", this.logPrefix, text, e.paramString()));
                String filterText = this.comboBoxModel.getFilterText();
                if (!Objects.equals(text, filterText)) {
                    log.info(String.format("%s Apply filter: '%s'", this.logPrefix, text));
                    JaxxComboBoxEditor.updateFilter(this.logPrefix, this.combobox, this.comboBoxModel, this.editorComponent, text, text);
                }
            }
        }
    }
}

