/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.jaxx.widgets.HtmlHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;

public class FilterableComboBoxRenderer
extends DefaultListCellRenderer {
    private static final Color defaultBackground = UIManager.getColor("List.background");
    private static final Color defaultForeground = UIManager.getColor("List.foreground");
    private static final Color alternateBackgroundColor = UIManager.getColor("Table.alternateRowColor");
    private final Supplier<String> highlightTextSupplier;

    public FilterableComboBoxRenderer(Supplier<String> highlightTextSupplier) {
        this.highlightTextSupplier = highlightTextSupplier;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            return this;
        }
        String text = value.toString();
        text = HtmlHighlighter.highlightText(text, this.highlightTextSupplier.get());
        this.setText(text);
        if (!isSelected) {
            this.setBackground(index % 2 == 0 ? defaultBackground : alternateBackgroundColor);
        }
        this.setForeground(defaultForeground);
        return this;
    }
}

