/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.AbstractJavaBean;
import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.decoration.Decorated;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.BeanUIUtil;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxConfig;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxModel;
import io.ultreia.java4all.lang.Setters;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterableComboBoxModel<O extends JavaBean>
extends AbstractJavaBean {
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    private static final Logger log = LogManager.getLogger(JaxxComboBoxModel.class);
    private final FilterableComboBoxConfig<O> config;
    O selectedItem;
    private Boolean reverseSort = false;
    private Object bean;
    private List<O> data;
    private final List<O> filteredData;
    private int index = 0;
    private Method mutator;

    public FilterableComboBoxModel(FilterableComboBoxConfig<O> config) {
        this.config = config;
        this.filteredData = new ArrayList<O>();
    }

    public Boolean getReverseSort() {
        return this.reverseSort;
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.getReverseSort();
        this.reverseSort = Objects.equals(true, reverseSort);
        this.firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, this.reverseSort);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Object oldValue = this.getBean();
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public List<O> getData() {
        return this.data;
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.getData();
        this.data = data;
        if (data != null && this.config.isBeanDecoratorAware()) {
            Decorator decorator = this.config.getDecorator();
            for (JavaBean datum : data) {
                ((Decorated)datum).registerDecorator(decorator);
            }
        }
        this.firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public O getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(O selectedItem) {
        Decorated item;
        O oldValue = this.getSelectedItem();
        this.selectedItem = selectedItem;
        if (this.config.isBeanDecoratorAware() && selectedItem instanceof Decorated && (item = (Decorated)selectedItem).decorator().isEmpty()) {
            item.registerDecorator(this.config.getDecorator());
        }
        if (!Objects.equals(oldValue, selectedItem)) {
            this.firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, selectedItem);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        int oldValue = this.getIndex();
        this.index = index;
        this.firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public List<O> getFilteredData() {
        return this.filteredData;
    }

    public List<O> updateFilteredData(String filterText) {
        this.filteredData.clear();
        for (JavaBean originalItem : this.data) {
            if (!this.acceptFilter(filterText, originalItem)) continue;
            this.filteredData.add(originalItem);
        }
        return this.filteredData;
    }

    private boolean acceptFilter(String filterText, O item) {
        if (filterText.isEmpty()) {
            return true;
        }
        return item.toString().toLowerCase().contains(filterText.toLowerCase());
    }

    public FilterableComboBoxConfig<O> getConfig() {
        return this.config;
    }

    public boolean isEmpty() {
        return this.getData() == null || this.getData().isEmpty();
    }

    public void addItems(Iterable<O> items) {
        List<O> data = this.getData();
        boolean wasEmpty = data.isEmpty();
        boolean beanDecoratorAware = this.config.isBeanDecoratorAware();
        Decorator decorator = this.config.getDecorator();
        for (JavaBean item : items) {
            data.add(item);
            if (!beanDecoratorAware) continue;
            ((Decorated)item).registerDecorator(decorator);
        }
        this.firePropertyChange(PROPERTY_DATA, null, this.getData());
        this.fireEmpty(wasEmpty);
    }

    public void removeItems(Iterable<O> items) {
        List<O> data = this.getData();
        boolean needUpdate = false;
        for (JavaBean item : items) {
            boolean remove = data.remove(item);
            if (!remove) continue;
            O selectedItem = this.getSelectedItem();
            if (item == selectedItem) {
                this.setSelectedItem(null);
            }
            needUpdate = true;
        }
        if (needUpdate) {
            this.firePropertyChange(PROPERTY_DATA, null, this.getData());
            this.fireEmpty(false);
        }
    }

    public void addItem(O item) {
        this.addItems(Collections.singleton(item));
    }

    public void removeItem(O item) {
        this.removeItems(Collections.singleton(item));
    }

    void fireEmpty(boolean wasEmpty) {
        this.firePropertyChange("empty", wasEmpty, this.isEmpty());
    }

    void mutateBeanProperty(O newValue) {
        Object bean = this.getBean();
        if (this.mutator == null && bean != null && this.config.getProperty() != null) {
            this.mutator = Setters.getMutator(bean, this.config.getProperty());
        }
        log.info(String.format("%s \u2192 set new value: %s", this.config.getProperty(), newValue));
        BeanUIUtil.invokeMethod(this.mutator, bean, newValue);
    }
}

