/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBox;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;

public class FilterableComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor,
AncestorListener,
PropertyChangeListener {
    private final FilterableComboBox<? super JavaBean> component;
    private Object value;

    public FilterableComboBoxCellEditor(FilterableComboBox<?> editor) {
        this.component = editor;
        JComboBox<?> comboBox = editor.getCombobox();
        this.component.setOpaque(false);
        ((JComponent)comboBox.getEditor().getEditorComponent()).addAncestorListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        JComboBox<? super JavaBean> comboBox = this.component.getCombobox();
        comboBox.putClientProperty("Table", table);
        this.component.setSelectedItem((JavaBean)((JavaBean)value));
        this.listen();
        return this.component;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        SwingUtilities.invokeLater(() -> this.component.getCombobox().requestFocusInWindow());
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.value = evt.getNewValue();
        this.stopCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.unListen();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.unListen();
        super.cancelCellEditing();
    }

    public FilterableComboBox<?> getComponent() {
        return this.component;
    }

    private void listen() {
        this.unListen();
        this.component.getModel().addPropertyChangeListener("selectedItem", this);
    }

    private void unListen() {
        this.component.getModel().removePropertyChangeListener("selectedItem", this);
    }
}

