/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets;

import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducer;
import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducerProvider;
import java.awt.Dimension;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.i18n.I18nDecoratorDefinition;
import org.nuiton.jaxx.runtime.i18n.I18nDecoratorDefinitions;

public class BeanUIUtil {
    public static final String DEFAULT_POPUP_LABEL = I18n.n((String)"bean.popup.label", (Object[])new Object[0]);
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n((String)"bean.sort.on", (Object[])new Object[0]);
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n((String)"bean.sort.off", (Object[])new Object[0]);

    public static void invokeMethod(Method mut, Object source, Object ... params) {
        if (mut != null) {
            try {
                mut.invoke(source, params);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static abstract class PopupHandler
    implements Runnable {
        public static final Logger log = LogManager.getLogger(PopupHandler.class);

        public abstract JPopupMenu getPopup();

        public abstract JComponent getInvoker();

        @Override
        public void run() {
            this.updatePopup();
            Dimension dim = this.getPopup().getPreferredSize();
            JComponent invoker = this.getInvoker();
            this.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
        }

        public void togglePopup() {
            boolean newValue;
            boolean bl = newValue = !this.getPopup().isVisible();
            if (log.isTraceEnabled()) {
                log.trace((Object)newValue);
            }
            if (!newValue) {
                if (this.getPopup() != null) {
                    this.getPopup().setVisible(false);
                }
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        protected void updatePopup() {
            this.getPopup().pack();
        }

        public void preparePopup(String selectedTip, String notSelectedTip, String i18nPrefix, String title, ButtonGroup indexes, JSeparator popupSeparator, JLabel popupLabel, AbstractButton sortUp, AbstractButton sortDown, Decorator decorator) {
            if (selectedTip == null) {
                selectedTip = DEFAULT_SELECTED_TOOLTIP;
            }
            if (notSelectedTip == null) {
                notSelectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
            }
            JPopupMenu popup = this.getPopup();
            I18nDecoratorDefinition i18nDecoratorDefinition = I18nDecoratorDefinitions.get().getDefinition(decorator);
            BeanPropertyI18nKeyProducer labelsBuilder = BeanPropertyI18nKeyProducerProvider.get().getDefaultLabelsBuilder();
            int nbContext = decorator.definition().contextCount();
            if (nbContext > 1) {
                LinkedHashMap labels = i18nDecoratorDefinition.computeLabels(decorator, labelsBuilder);
                int i = 0;
                for (Map.Entry entry : labels.entrySet()) {
                    String property = (String)entry.getKey();
                    String propertyI18n = (String)entry.getValue();
                    JRadioButtonMenuItem button = new JRadioButtonMenuItem(propertyI18n);
                    button.setName(property);
                    button.putClientProperty("$buttonGroup", indexes);
                    button.putClientProperty("$value", i++);
                    popup.add(button);
                    if (selectedTip != null) {
                        button.putClientProperty("$selected.toolTipText", I18n.t((String)selectedTip, (Object[])new Object[]{propertyI18n}));
                    }
                    if (notSelectedTip != null) {
                        button.putClientProperty("$not.selected.toolTipText", I18n.t((String)notSelectedTip, (Object[])new Object[]{propertyI18n}));
                    }
                    button.setSelected(false);
                    indexes.add(button);
                }
            }
            if (title == null) {
                title = DEFAULT_POPUP_LABEL;
                Class type = i18nDecoratorDefinition.getDecoratorType(decorator);
                Object beanI18nKey = type == null ? I18n.n((String)"bean.unknown.type", (Object[])new Object[0]) : i18nPrefix + Introspector.decapitalize(type.getSimpleName());
                String beanI18n = I18n.t((String)beanI18nKey, (Object[])new Object[0]);
                title = I18n.t((String)title, (Object[])new Object[]{beanI18n});
            } else {
                title = I18n.t((String)title, (Object[])new Object[0]);
            }
            sortDown.putClientProperty("$selected.toolTipText", I18n.t((String)"bean.sort.down.tip", (Object[])new Object[0]));
            sortDown.putClientProperty("$not.selected.toolTipText", I18n.t((String)"bean.sort.down.toSelect.tip", (Object[])new Object[0]));
            sortUp.putClientProperty("$selected.toolTipText", I18n.t((String)"bean.sort.up.tip", (Object[])new Object[0]));
            sortUp.putClientProperty("$not.selected.toolTipText", I18n.t((String)"bean.sort.up.toSelect.tip", (Object[])new Object[0]));
            if (nbContext < 2) {
                this.getPopup().remove(popupSeparator);
                this.getPopup().remove(popupLabel);
            }
            popupLabel.setText(title);
            this.getPopup().setLabel(title);
            this.getPopup().invalidate();
        }
    }
}

