package org.nuiton.jaxx.widgets.temperature;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class TemperatureEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_C_FORMAT_SELECTED = "cFormat.selected";
    public static final String BINDING_EDITOR_NUMBER_VALUE = "editor.numberValue";
    public static final String BINDING_F_FORMAT_SELECTED = "fFormat.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1VzXIbRRBuiUiyLcxPKCAHDioSHCeEUXLgggng2FJISrZV8iYV8CGMtCN5XaudYaY3XpeKHDhw4wU4cOVC5R1SnKjiwtXvQFUegZ7ZldbGUuz4gA6zo9nub7q//rr393+gZDTckHrAojhAGbE9niRMxxEGQ8Hurz56tNXdEz1cF6anA4VSQ/orFKG4A1V/cm4Q2E6LkOopUt0i1TOk+pocKhmJ6AjQSgsWDB6EwuwKgQjLM517xtS3J5YriYp1dtfUqKfd9ddPtw4LYv2XIkCiKPwKpf3xKwDkWV9oQTHwES629vgTXg95NKDgdBANKKFFe7YWcmM2+VB8D0+h0oKy4prAED45Fz0OzkElCmHuyv02j0R4E+HT/8a/H/gDgYahGCqhOcZaMC/fN3wy1Uo5sDJCaSh9ESJ8di6cDeucg5WFO8WTrI7RonjYFZptukeKYX3nJxDVvtRDji494tdSmTCzT8yyNOfj5pVe09kjXDpm2uF+IO/ESAFYy4u5Qz91sH/fP/5qLr36zl0q0ixVZPDUEin4XS1jRQRoWJrlQsJluXBzDRV2oKRjOka4PLtnrOw7ZJUK/vJswdtrnOGPz57q3/ZfHI5VXqbgaqd5HWlokpzSkuqMgY3tzVTiMQZhfYOrlR2YNyKkaeC6/erLI9/OLCl6iuJti8QsEvuam11CK1UOn//x3nd/vwbFJiyEkvtNbu3vwTzuamJMhn6ivvzKBff6/hytb9kwSWr9rO43R8tHZJkW99q4koxEl8Yg/Ic8jMXytR8S4vHqy3mchP1s68Wfv/780fMxlwXK4spZPHM+S99COYjCIBJuZmTjYOqMqCojYl/mvT6t+2Hcsyrruw/dunSCJNtM3Vykx/Q935e92PBuSIIs9Xlo6HkBRUJ81kYn6GRrlscW74qQ+COPJ5ZKhHenmdL7KkoZeoHyHODSLMDxmAtk5GDnTFYphOvTfGq3b9dc5tY5PXTltOlfd8WxuxuQT4X/kaLm2Slqnomi5jkoar4CRf2zUVRCWEiHtnegKKHFUZPaFFnPSpIiWkxftqkVhY4QPhht2xH5wDb5emPt3sZq69bj9qrnNTqbNoFstBzQjB1N/5ywdmer3eh43zz2Ghu0WfUedBrkWomN2A4GUV6Oanr3w5TqS6NJ5keAZ6SffalOy94OmpAfSNIIvPG5z5HXukHkU4JfnEAt2HXhVER73LVLbzrCO4TwL/qvBbqTCQAA";
    private static final Logger log = LogManager.getLogger(TemperatureEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton cFormat;
    protected NumberEditor editor;
    protected JRadioButton fFormat;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected TemperatureEditorHandler handler;
    protected TemperatureEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TemperatureEditor $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JLabel label) { handler.init(this, label); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setConfig(TemperatureEditorConfig config) { model.setConfig(config); }
    public void setStorageTemperature(Float temperature) { model.setStorageTemperature(temperature); }
    public void setTemperature(Float temperature) { model.setTemperature(temperature); }
    public void setFormat(TemperatureFormat format) { model.setFormat(format); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemperatureEditor() {
        $initialize();
    }

    public TemperatureEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemperatureEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemperatureEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemperatureEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TemperatureEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemperatureEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TemperatureEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getCFormat() {
        return cFormat;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public JRadioButton getFFormat() {
        return fFormat;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public TemperatureEditorHandler getHandler() {
        return handler;
    }

    public TemperatureEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCFormat() {
        { ButtonGroup $buttonGroup = formatBG; cFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(cFormat); }
    }

    protected void addChildrenToFFormat() {
        { ButtonGroup $buttonGroup = formatBG; fFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fFormat); }
    }

    protected void addChildrenToFormatPanel() {
        formatPanel.add(cFormat);
        formatPanel.add(fFormat);
    }

    protected void createCFormat() {
        $objectMap.put("cFormat", cFormat = new JRadioButton());
        
        cFormat.setName("cFormat");
        cFormat.setFocusable(false);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
    }

    protected void createFFormat() {
        $objectMap.put("fFormat", fFormat = new JRadioButton());
        
        fFormat.setName("fFormat");
        fFormat.setFocusable(false);
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(1, 0, 2, 0));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TemperatureEditorModel.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createEditor();
        createFormatPanel();
        createCFormat();
        createFFormat();
        createFormatBG();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new TemperatureEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((TemperatureFormat)formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("temperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setNumberValue(model.getTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("temperature", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_C_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cFormat.setSelected(TemperatureFormat.C == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_F_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fFormat.setSelected(TemperatureFormat.F == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(editor, BorderLayout.CENTER);
        add(formatPanel, BorderLayout.EAST);
        addChildrenToFormatPanel();
        addChildrenToCFormat();
        addChildrenToFFormat();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 11 property setters
        editor.setNumberType(Float.class);
        editor.setNumberPattern(SwingUtil.DECIMAL1_PATTERN);
        editor.setProperty(TemperatureEditorModel.PROPERTY_TEMPERATURE);
        cFormat.setText(TemperatureFormat.C.getLabel());
        { cFormat.putClientProperty("$value", TemperatureFormat.C);  Object $buttonGroup = cFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        cFormat.setToolTipText(TemperatureFormat.C.getDescription());
        fFormat.setText(TemperatureFormat.F.getLabel());
        { fFormat.putClientProperty("$value", TemperatureFormat.F);  Object $buttonGroup = fFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        fFormat.setToolTipText(TemperatureFormat.F.getDescription());
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
