package org.nuiton.jaxx.widgets.gis.validators;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;

import java.util.Map;
import java.util.Objects;

import static io.ultreia.java4all.i18n.I18n.n;

/**
 * Created on 03/11/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3
 */
public class CoordinateLongitudeDtoFieldValidator extends FieldValidatorSupport {

    private String editorName;

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    @Override
    public void validate(Object object) throws ValidationException {

        if (StringUtils.isEmpty(editorName)) {
            throw new ValidationException("editorName is not defined");
        }

        @SuppressWarnings("unchecked") Map<String, CoordinatesEditor> map = (Map<String, CoordinatesEditor>) getFieldValue("coordinatesEditors", object);
        if (map == null) {
            //FIXME For service validation, need to inject this map
            return;
        }
        CoordinatesEditor coordinatesEditor = map.get(editorName);
        //FIXME une validation est lancé dans l'ui alors que l'on ne devrait pas et on a pas ce composant alors
        if (coordinatesEditor == null) {
            return;
        }
        Objects.requireNonNull(coordinatesEditor, "can't find editor named " + editorName);

        CoordinateFormat format = coordinatesEditor.getModel().getFormat();
        switch (format) {

            case dd:
                validate(coordinatesEditor.getLongitudeDd());
                break;
            case dms:
                validate(coordinatesEditor.getLongitudeDms());
                break;
            case dmd:
                validate(coordinatesEditor.getLongitudeDmd());
                break;
        }

    }

    @Override
    public String getValidatorType() {
        return "coordinate_longitude";
    }

    private void validate(AbsoluteDdCoordinateEditor editor) {
        AbsoluteDdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null) {
            if (degree > 180) {
                setMessageKey(n("jaxx.validation.coordinate.degree.longitude.outOfBound"));
                addFieldError(getFieldName(), degree);
            }
        }
    }

    private void validate(AbsoluteDmsCoordinateEditor editor) {
        AbsoluteDmsCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null) {
            if (degree > 180) {
                setMessageKey(n("jaxx.validation.coordinate.degree.longitude.outOfBound"));
                addFieldError(getFieldName(), degree);
            }
        }
        Integer minute = model.getMinute();
        if (minute != null) {

            if (minute > 59) {
                setMessageKey(n("jaxx.validation.coordinate.minute.longitude.outOfBound"));
                addFieldError(getFieldName(), minute);
            }
        }
        Integer second = model.getSecond();
        if (second != null) {
            if (second > 59) {
                setMessageKey(n("jaxx.validation.coordinate.second.longitude.outOfBound"));
                addFieldError(getFieldName(), second);
            }
        }
    }

    private void validate(AbsoluteDmdCoordinateEditor editor) {

        AbsoluteDmdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null) {
            if (degree > 180) {
                setMessageKey(n("jaxx.validation.coordinate.degree.longitude.outOfBound"));
                addFieldError(getFieldName(), degree);
            }
        }
        Integer minute = model.getMinute();
        if (minute != null) {

            if (minute > 59) {
                setMessageKey(n("jaxx.validation.coordinate.minute.longitude.outOfBound"));
                addFieldError(getFieldName(), minute);
            }
        }

    }
}
