package org.nuiton.jaxx.widgets.gis.absolute;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.CardLayout2Ext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import static io.ultreia.java4all.i18n.I18n.t;

public class CoordinatesEditor extends Table implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_GLOBAL_RESET_TIP = "showGlobalResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DD_FORMAT_SELECTED = "ddFormat.selected";
    public static final String BINDING_DMD_FORMAT_SELECTED = "dmdFormat.selected";
    public static final String BINDING_DMS_FORMAT_SELECTED = "dmsFormat.selected";
    public static final String BINDING_GLOBAL_RESET_BUTTON_TOOL_TIP_TEXT = "globalResetButton.toolTipText";
    public static final String BINDING_LATITUDE_DD_DISPLAY_ZERO_WHEN_NULL = "latitudeDd.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DD_ENABLED = "latitudeDd.enabled";
    public static final String BINDING_LATITUDE_DD_FILL_WITH_ZERO = "latitudeDd.fillWithZero";
    public static final String BINDING_LATITUDE_DD_SHOW_RESET = "latitudeDd.showReset";
    public static final String BINDING_LATITUDE_DD_VALUE = "latitudeDd.value";
    public static final String BINDING_LATITUDE_DMD_DISPLAY_ZERO_WHEN_NULL = "latitudeDmd.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DMD_ENABLED = "latitudeDmd.enabled";
    public static final String BINDING_LATITUDE_DMD_FILL_WITH_ZERO = "latitudeDmd.fillWithZero";
    public static final String BINDING_LATITUDE_DMD_SHOW_RESET = "latitudeDmd.showReset";
    public static final String BINDING_LATITUDE_DMD_VALUE = "latitudeDmd.value";
    public static final String BINDING_LATITUDE_DMS_DISPLAY_ZERO_WHEN_NULL = "latitudeDms.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DMS_ENABLED = "latitudeDms.enabled";
    public static final String BINDING_LATITUDE_DMS_FILL_WITH_ZERO = "latitudeDms.fillWithZero";
    public static final String BINDING_LATITUDE_DMS_SHOW_RESET = "latitudeDms.showReset";
    public static final String BINDING_LATITUDE_DMS_VALUE = "latitudeDms.value";
    public static final String BINDING_LATITUDE_LAYOUT_SELECTED = "latitudeLayout.selected";
    public static final String BINDING_LONGITUDE_DD_DISPLAY_ZERO_WHEN_NULL = "longitudeDd.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DD_ENABLED = "longitudeDd.enabled";
    public static final String BINDING_LONGITUDE_DD_FILL_WITH_ZERO = "longitudeDd.fillWithZero";
    public static final String BINDING_LONGITUDE_DD_SHOW_RESET = "longitudeDd.showReset";
    public static final String BINDING_LONGITUDE_DD_VALUE = "longitudeDd.value";
    public static final String BINDING_LONGITUDE_DMD_DISPLAY_ZERO_WHEN_NULL = "longitudeDmd.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DMD_ENABLED = "longitudeDmd.enabled";
    public static final String BINDING_LONGITUDE_DMD_FILL_WITH_ZERO = "longitudeDmd.fillWithZero";
    public static final String BINDING_LONGITUDE_DMD_SHOW_RESET = "longitudeDmd.showReset";
    public static final String BINDING_LONGITUDE_DMD_VALUE = "longitudeDmd.value";
    public static final String BINDING_LONGITUDE_DMS_DISPLAY_ZERO_WHEN_NULL = "longitudeDms.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DMS_ENABLED = "longitudeDms.enabled";
    public static final String BINDING_LONGITUDE_DMS_FILL_WITH_ZERO = "longitudeDms.fillWithZero";
    public static final String BINDING_LONGITUDE_DMS_SHOW_RESET = "longitudeDms.showReset";
    public static final String BINDING_LONGITUDE_DMS_VALUE = "longitudeDms.value";
    public static final String BINDING_LONGITUDE_LAYOUT_SELECTED = "longitudeLayout.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";
    public static final String BINDING_MODEL_QUADRANT = "model.quadrant";
    public static final String BINDING_QUADRANT1_ENABLED = "quadrant1.enabled";
    public static final String BINDING_QUADRANT1_SELECTED = "quadrant1.selected";
    public static final String BINDING_QUADRANT2_ENABLED = "quadrant2.enabled";
    public static final String BINDING_QUADRANT2_SELECTED = "quadrant2.selected";
    public static final String BINDING_QUADRANT3_ENABLED = "quadrant3.enabled";
    public static final String BINDING_QUADRANT3_SELECTED = "quadrant3.selected";
    public static final String BINDING_QUADRANT4_ENABLED = "quadrant4.enabled";
    public static final String BINDING_QUADRANT4_SELECTED = "quadrant4.selected";
    public static final String BINDING_TOOLBAR_LEFT_ENABLED = "toolbarLeft.enabled";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(CoordinatesEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CoordinatesEditor coordinateEditorTopPanel;
    protected Table coordinatesPanel;
    protected JRadioButton ddFormat;
    protected JRadioButton dmdFormat;
    protected JRadioButton dmsFormat;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected JButton globalResetButton;
    protected CoordinatesEditorHandler handler;
    protected AbsoluteDdCoordinateEditor latitudeDd;
    protected AbsoluteDmdCoordinateEditor latitudeDmd;
    protected AbsoluteDmsCoordinateEditor latitudeDms;
    protected JPanel latitudeEditor;
    protected JLabel latitudeLabel;
    protected CardLayout2Ext latitudeLayout;
    protected AbsoluteCoordinateEditorModel latitudeModel;
    protected AbsoluteDdCoordinateEditor longitudeDd;
    protected AbsoluteDmdCoordinateEditor longitudeDmd;
    protected AbsoluteDmsCoordinateEditor longitudeDms;
    protected JPanel longitudeEditor;
    protected JLabel longitudeLabel;
    protected CardLayout2Ext longitudeLayout;
    protected AbsoluteCoordinateEditorModel longitudeModel;
    protected CoordinatesEditorModel model;
    protected JToggleButton quadrant1;
    protected JToggleButton quadrant2;
    protected JToggleButton quadrant3;
    protected JToggleButton quadrant4;
    protected JAXXButtonGroup quadrantBG;
    protected JPanel quadrantEditor;
    protected String showGlobalResetTip;
    protected JToolBar toolbarLeft;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setPropertyQuadrant(String property) { model.setPropertyQuadrant(property); }
    public void setPropertyLatitude(String property) { model.setPropertyLatitude(property); }
    public void setPropertyLongitude(String property) { model.setPropertyLongitude(property); }
    public void setQuadrant(Integer quadrant) { model.setQuadrant(quadrant); }
    public void setLatitude(Float latitude) { model.setLatitude(latitude); }
    public void setLongitude(Float longitude) { model.setLongitude(longitude); }
    public void setLatitudeAndLongitude(Float latitude, Float longitude) { model.setLatitudeAndLongitude(latitude, longitude); }
    public void setFormat(CoordinateFormat format) { model.setFormat(format); }
    public void setShowResetButton(boolean showResetButton) { model.setShowResetButton(showResetButton); }
    public void setShowGlobalResetButton(boolean showGlobalResetButton) { model.setShowGlobalResetButton(showGlobalResetButton); }
    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) { model.setDisplayZeroWhenNull(displayZeroWhenNull); }
    public void setFillWithZero(boolean fillWithZero) { model.setFillWithZero(fillWithZero); }
    public void resetQuadrant() { handler.resetQuadrant(); }
    public void reset() { handler.resetEditor(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditor() {
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__globalResetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        reset();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getCoordinatesPanel() {
        return coordinatesPanel;
    }

    public JRadioButton getDdFormat() {
        return ddFormat;
    }

    public JRadioButton getDmdFormat() {
        return dmdFormat;
    }

    public JRadioButton getDmsFormat() {
        return dmsFormat;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public JButton getGlobalResetButton() {
        return globalResetButton;
    }

    public CoordinatesEditorHandler getHandler() {
        return handler;
    }

    public AbsoluteDdCoordinateEditor getLatitudeDd() {
        return latitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLatitudeDmd() {
        return latitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLatitudeDms() {
        return latitudeDms;
    }

    public JPanel getLatitudeEditor() {
        return latitudeEditor;
    }

    public JLabel getLatitudeLabel() {
        return latitudeLabel;
    }

    public CardLayout2Ext getLatitudeLayout() {
        return latitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLatitudeModel() {
        return latitudeModel;
    }

    public AbsoluteDdCoordinateEditor getLongitudeDd() {
        return longitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLongitudeDmd() {
        return longitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLongitudeDms() {
        return longitudeDms;
    }

    public JPanel getLongitudeEditor() {
        return longitudeEditor;
    }

    public JLabel getLongitudeLabel() {
        return longitudeLabel;
    }

    public CardLayout2Ext getLongitudeLayout() {
        return longitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLongitudeModel() {
        return longitudeModel;
    }

    public CoordinatesEditorModel getModel() {
        return model;
    }

    public JToggleButton getQuadrant1() {
        return quadrant1;
    }

    public JToggleButton getQuadrant2() {
        return quadrant2;
    }

    public JToggleButton getQuadrant3() {
        return quadrant3;
    }

    public JToggleButton getQuadrant4() {
        return quadrant4;
    }

    public JAXXButtonGroup getQuadrantBG() {
        return quadrantBG;
    }

    public JPanel getQuadrantEditor() {
        return quadrantEditor;
    }

    public String getShowGlobalResetTip() {
        return showGlobalResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowGlobalResetTip(String showGlobalResetTip) {
        String oldValue = this.showGlobalResetTip;
        this.showGlobalResetTip = showGlobalResetTip;
        firePropertyChange(PROPERTY_SHOW_GLOBAL_RESET_TIP, oldValue, showGlobalResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCoordinateEditorTopPanel() {
        add(toolbarLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(quadrantEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(coordinatesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(formatPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToCoordinatesPanel() {
        coordinatesPanel.add(latitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(latitudeEditor, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(longitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(longitudeEditor, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToDdFormat() {
        { ButtonGroup $buttonGroup = formatBG; ddFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(ddFormat); }
    }

    protected void addChildrenToDmdFormat() {
        { ButtonGroup $buttonGroup = formatBG; dmdFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmdFormat); }
    }

    protected void addChildrenToDmsFormat() {
        { ButtonGroup $buttonGroup = formatBG; dmsFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmsFormat); }
    }

    protected void addChildrenToFormatPanel() {
        formatPanel.add(dmsFormat);
        formatPanel.add(dmdFormat);
        formatPanel.add(ddFormat);
    }

    protected void addChildrenToLatitudeEditor() {
        latitudeEditor.add(latitudeDd, CoordinateFormat.dd.name());
        latitudeEditor.add(latitudeDms, CoordinateFormat.dms.name());
        latitudeEditor.add(latitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToLongitudeEditor() {
        longitudeEditor.add(longitudeDd, CoordinateFormat.dd.name());
        longitudeEditor.add(longitudeDms, CoordinateFormat.dms.name());
        longitudeEditor.add(longitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToQuadrant1() {
        { ButtonGroup $buttonGroup = quadrantBG; quadrant1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant1); }
    }

    protected void addChildrenToQuadrant2() {
        { ButtonGroup $buttonGroup = quadrantBG; quadrant2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant2); }
    }

    protected void addChildrenToQuadrant3() {
        { ButtonGroup $buttonGroup = quadrantBG; quadrant3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant3); }
    }

    protected void addChildrenToQuadrant4() {
        { ButtonGroup $buttonGroup = quadrantBG; quadrant4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant4); }
    }

    protected void addChildrenToQuadrantEditor() {
        quadrantEditor.add(quadrant4);
        quadrantEditor.add(quadrant1);
        quadrantEditor.add(quadrant3);
        quadrantEditor.add(quadrant2);
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(globalResetButton);
    }

    protected void createCoordinatesPanel() {
        $objectMap.put("coordinatesPanel", coordinatesPanel = new Table());
        
        coordinatesPanel.setName("coordinatesPanel");
    }

    protected void createDdFormat() {
        $objectMap.put("ddFormat", ddFormat = new JRadioButton());
        
        ddFormat.setName("ddFormat");
        ddFormat.setFocusable(false);
        ddFormat.setText(t("jaxx.coordinate.format.dd"));
        ddFormat.setToolTipText(t("jaxx.coordinate.format.dd.tip"));
    }

    protected void createDmdFormat() {
        $objectMap.put("dmdFormat", dmdFormat = new JRadioButton());
        
        dmdFormat.setName("dmdFormat");
        dmdFormat.setFocusable(false);
        dmdFormat.setText(t("jaxx.coordinate.format.dmd"));
        dmdFormat.setToolTipText(t("jaxx.coordinate.format.dmd.tip"));
    }

    protected void createDmsFormat() {
        $objectMap.put("dmsFormat", dmsFormat = new JRadioButton());
        
        dmsFormat.setName("dmsFormat");
        dmsFormat.setFocusable(false);
        dmsFormat.setText(t("jaxx.coordinate.format.dms"));
        dmsFormat.setToolTipText(t("jaxx.coordinate.format.dms.tip"));
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(0,1,0,0));
    }

    protected void createGlobalResetButton() {
        $objectMap.put("globalResetButton", globalResetButton = new JButton());
        
        globalResetButton.setName("globalResetButton");
        globalResetButton.setFocusable(false);
        globalResetButton.setFocusPainted(false);
        globalResetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__globalResetButton"));
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = new AbsoluteDdCoordinateEditor());
        
        latitudeDd.setName("latitudeDd");
        latitudeDd.setPropertyDecimal("ddDecimal");
        latitudeDd.setPropertyDegree("ddDegree");
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        latitudeDmd.setName("latitudeDmd");
        latitudeDmd.setPropertyDecimal("dmdDecimal");
        latitudeDmd.setPropertyMinute("dmdMinute");
        latitudeDmd.setPropertyDegree("dmdDegree");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new AbsoluteDmsCoordinateEditor());
        
        latitudeDms.setName("latitudeDms");
        latitudeDms.setPropertyMinute("dmsMinute");
        latitudeDms.setPropertySecond("dmsSecond");
        latitudeDms.setPropertyDegree("dmsDegree");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JPanel());
        
        latitudeEditor.setName("latitudeEditor");
        latitudeEditor.setLayout(latitudeLayout);
    }

    protected void createLatitudeLabel() {
        $objectMap.put("latitudeLabel", latitudeLabel = new JLabel());
        
        latitudeLabel.setName("latitudeLabel");
        latitudeLabel.setText(t("jaxx.common.latitude.short"));
        latitudeLabel.setToolTipText(t("jaxx.common.latitude"));
    }

    protected void createLatitudeLayout() {
        $objectMap.put("latitudeLayout", latitudeLayout = new CardLayout2Ext(this, "latitudeEditor"));
    }

    protected void createLatitudeModel() {
        $objectMap.put("latitudeModel", latitudeModel = model.getLatitudeModel());
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = new AbsoluteDdCoordinateEditor());
        
        longitudeDd.setName("longitudeDd");
        longitudeDd.setPropertyDecimal("ddDecimal");
        longitudeDd.setPropertyDegree("ddDegree");
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        longitudeDmd.setName("longitudeDmd");
        longitudeDmd.setPropertyDecimal("dmdDecimal");
        longitudeDmd.setPropertyMinute("dmdMinute");
        longitudeDmd.setPropertyDegree("dmdDegree");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new AbsoluteDmsCoordinateEditor());
        
        longitudeDms.setName("longitudeDms");
        longitudeDms.setPropertyMinute("dmsMinute");
        longitudeDms.setPropertySecond("dmsSecond");
        longitudeDms.setPropertyDegree("dmsDegree");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JPanel());
        
        longitudeEditor.setName("longitudeEditor");
        longitudeEditor.setLayout(longitudeLayout);
    }

    protected void createLongitudeLabel() {
        $objectMap.put("longitudeLabel", longitudeLabel = new JLabel());
        
        longitudeLabel.setName("longitudeLabel");
        longitudeLabel.setText(t("jaxx.common.longitude.short"));
        longitudeLabel.setToolTipText(t("jaxx.common.longitude"));
    }

    protected void createLongitudeLayout() {
        $objectMap.put("longitudeLayout", longitudeLayout = new CardLayout2Ext(this, "longitudeEditor"));
    }

    protected void createLongitudeModel() {
        $objectMap.put("longitudeModel", longitudeModel = model.getLongitudeModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorModel.class));
    }

    protected void createQuadrant1() {
        $objectMap.put("quadrant1", quadrant1 = new JToggleButton());
        
        quadrant1.setName("quadrant1");
        quadrant1.setText(t("jaxx.common.quadrant1"));
    }

    protected void createQuadrant2() {
        $objectMap.put("quadrant2", quadrant2 = new JToggleButton());
        
        quadrant2.setName("quadrant2");
        quadrant2.setText(t("jaxx.common.quadrant2"));
    }

    protected void createQuadrant3() {
        $objectMap.put("quadrant3", quadrant3 = new JToggleButton());
        
        quadrant3.setName("quadrant3");
        quadrant3.setText(t("jaxx.common.quadrant3"));
    }

    protected void createQuadrant4() {
        $objectMap.put("quadrant4", quadrant4 = new JToggleButton());
        
        quadrant4.setName("quadrant4");
        quadrant4.setText(t("jaxx.common.quadrant4"));
    }

    protected void createQuadrantBG() {
        $objectMap.put("quadrantBG", quadrantBG = new JAXXButtonGroup());
    }

    protected void createQuadrantEditor() {
        $objectMap.put("quadrantEditor", quadrantEditor = new JPanel());
        
        quadrantEditor.setName("quadrantEditor");
        quadrantEditor.setLayout(new GridLayout(2,2,0,0));
    }

    protected void createShowGlobalResetTip() {
        $objectMap.put("showGlobalResetTip", showGlobalResetTip = t("jaxx.coordinate.action.global.reset.tip"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        coordinateEditorTopPanel = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("coordinateEditorTopPanel", coordinateEditorTopPanel);
        createModel();
        createLatitudeModel();
        createLongitudeModel();
        createShowGlobalResetTip();
        createLatitudeLayout();
        createLongitudeLayout();
        createToolbarLeft();
        createGlobalResetButton();
        createQuadrantEditor();
        createQuadrant4();
        createQuadrant1();
        createQuadrant3();
        createQuadrant2();
        createCoordinatesPanel();
        createLatitudeLabel();
        createLatitudeEditor();
        createLatitudeDd();
        createLatitudeDms();
        createLatitudeDmd();
        createLongitudeLabel();
        createLongitudeEditor();
        createLongitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createFormatPanel();
        createDmsFormat();
        createDmdFormat();
        createDdFormat();
        createQuadrantBG();
        createFormatBG();
        // inline creation of coordinateEditorTopPanel
        setName("coordinateEditorTopPanel");
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new CoordinatesEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 48 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (quadrantBG != null) {
                    model.setQuadrant((Integer)quadrantBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((CoordinateFormat)formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showGlobalResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toolbarLeft.setVisible(model.isShowGlobalResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showGlobalResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GLOBAL_RESET_BUTTON_TOOL_TIP_TEXT, true ,"showGlobalResetTip") {
        
            @Override
            public void processDataBinding() {
                globalResetButton.setToolTipText(getShowGlobalResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT4_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant4.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT4_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant4.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 4));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant1.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT3_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant3.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 3));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT2_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant2.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 2));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDd.setValue(latitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDms.setValue(latitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDmd.setValue(latitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDd.setValue(longitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDms.setValue(longitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDmd.setValue(longitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMS_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmsFormat.setSelected(model.getFormat() == CoordinateFormat.dms);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmdFormat.setSelected(model.getFormat() == CoordinateFormat.dmd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ddFormat.setSelected(model.getFormat() == CoordinateFormat.dd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCoordinateEditorTopPanel();
        addChildrenToToolbarLeft();
        addChildrenToQuadrantEditor();
        addChildrenToQuadrant4();
        addChildrenToQuadrant1();
        addChildrenToQuadrant3();
        addChildrenToQuadrant2();
        addChildrenToCoordinatesPanel();
        addChildrenToLatitudeEditor();
        addChildrenToLongitudeEditor();
        addChildrenToFormatPanel();
        addChildrenToDmsFormat();
        addChildrenToDmdFormat();
        addChildrenToDdFormat();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 48 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 27 property setters
        globalResetButton.setIcon(SwingUtil.getUIManagerActionIcon("coordinate-reset"));
        { quadrant4.putClientProperty("$value", Integer.valueOf(4));  Object $buttonGroup = quadrant4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant1.putClientProperty("$value", Integer.valueOf(1));  Object $buttonGroup = quadrant1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant3.putClientProperty("$value", Integer.valueOf(3));  Object $buttonGroup = quadrant3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant2.putClientProperty("$value", Integer.valueOf(2));  Object $buttonGroup = quadrant2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        coordinatesPanel.setMinimumSize(new java.awt.Dimension(100,26));
        latitudeLabel.setLabelFor(latitudeEditor);
        latitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDd.setBean(latitudeModel);
        latitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDms.setBean(latitudeModel);
        latitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDmd.setBean(latitudeModel);
        longitudeLabel.setLabelFor(longitudeEditor);
        longitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDd.setBean(longitudeModel);
        longitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDms.setBean(longitudeModel);
        longitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDmd.setBean(longitudeModel);
        { dmsFormat.putClientProperty("$value", CoordinateFormat.dms);  Object $buttonGroup = dmsFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { dmdFormat.putClientProperty("$value", CoordinateFormat.dmd);  Object $buttonGroup = dmdFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ddFormat.putClientProperty("$value", CoordinateFormat.dd);  Object $buttonGroup = ddFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
