package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.ValidatorField;
import org.nuiton.jaxx.validator.swing.ui.ImageValidationUI;
import org.nuiton.jaxx.widgets.datetime.actions.UnlimitedTimeEditorResetAction;
import static io.ultreia.java4all.i18n.I18n.t;

public class UnlimitedTimeEditor extends JPanel implements BeanScopeAware, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_TOOLBAR_RESET_VISIBLE = "toolbarReset.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS28TMRB2UpK+UkoL4gAIKt7PDUgICYp4lFIFlAKigCp6wcm6iSvHXmxvs1DBgQM3bnDhwJUL6n+oOCFx4dr/gMRPYOzdZDdt0iQQKU52dvzNzOeZz99+o4yS6LyQFYf7VAvurOAgcKTPNa0R5/7txcWHpRVS1rNElSX1tJAo/KTSKL2ERt2mXWnkLBUBKR8i5Q1SPkLK3xE1T3DCE0DTRTSi9CtGVJUQrdHpjpvLSuUXmp7TgefLKFbbrNvF+vn+0maKzH5OIxR4kP44lH2uD4C46l1FlKauRpPFFbyK8wzzCiQnKa9AQWPGdodhpR7gGnmJ3qLBIsp6WAKYRhf+iR4LZ6ECT6Oh4/cfYU7YRY0ub82/Tt0K0cpxsSa2kKec0RrVxH0CT3dd8JSeZ7GyGmVqwiVMo6v/AjNv9sZYw1XhhzaNDhsOAkfVgRJnwaOcE/nAr5XI1k2jNcp9TazVmCYSeKoq6o+JMn0xYfAcw7MzIwQjmCf8VjGjkKeQ0H1b62i+a+Ri1mcNYwKEkWVtSYVTTSYfMm28hmNnw0gRl7Y7W6PxOtB0zmlIuIRlVMm+Fv8n8G4Gy9YdGRm67m1xnfE1VGVcpmL2iD2IZoqHWvMcMScSntXWwNGZGMeTTf8sM+kXzNOR1je58JhCLGM72/p+UgGjRBaoK2SipqORl0QnO80ZzLUTz3U8Yqkl4MEHs0bHOkuKUYXH4BXqwbHOemDCWMd362/l1/qfzYYI5CC5qW67EnoHE+lJ4RGpqcltPFQAX1OWn8fe9BK0LWEgllYMT+2c+ULkCdlDFmGPGySngFUV0DKDmxvf97/4NYDSc2iECezOYeN/DzqwCk1SFcwNvJu3bHK5+hCse+C7S6OxkpBwHo8w5TCy0FLLmEFPoazw8EufxIbhZVH2FS6xFhuE0klbAOSe2pncZi3rD//8+PLhxEaD4BSUdryXnTHJmecoS0FvOLE6G0loW10d9RTxXRHrYzvFREYzG7MWzfwVu17bRt7Af5EX+AZ11pZt/s2Z0IPR7HaJnIKJrwpJXwuuMbvNaIXX7JWRLcMPkduxIaqmmhGvO3IGhNCkPrlmFd8BcS+AOKjTZ960w421vBt2Or5ERteau95A1YQbZoC/sTWq7oYPHcIlhKqHeDuypKH9SQDPufiicgrtgkZq1wd5+2Ly5q0edqIveav1QeDYWmJfnxS2KHQPNQ2uUkVt544D9kLjqu2EnrzEekHvI/PwuusBFA7slYBJQruvw+2Np0qUu3CZ3dgGmjLrSFdEY/5olk/tEQ4Cwl+VBg1sHgsAAA==";
    private static final Logger log = LogManager.getLogger(UnlimitedTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel editorPanel;
    protected UnlimitedTimeEditorHandler handler;
    protected JSpinner hourEditor;
    protected SpinnerNumberModel hourModel;
    protected JLabel labelH;
    protected JPanel leftPanel;
    protected JSpinner minuteEditor;
    protected SpinnerNumberModel minuteModel;
    protected UnlimitedTimeEditorModel model;
    protected JButton reset;
    protected Boolean showReset;
    protected JToolBar sliderHidorToolBar;
    protected JLabel timeLabel;
    protected JToolBar toolbarReset;
    protected SwingValidator<UnlimitedTimeEditorModel> validator;
    protected ArrayListMultimap<JComponent, ValidatorField> validatorEditors;
    protected List<String> validatorIds;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private UnlimitedTimeEditor $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setPropertyTime(String property) { model.setPropertyTime(property); }
    
    public void setTime(Integer time) { model.setTime(time); }
    
    public void setLabel(String label) { timeLabel.setText(label); }
    
    public void reset() { handler.reset(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UnlimitedTimeEditor() {
        $initialize();
    }

    public UnlimitedTimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UnlimitedTimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UnlimitedTimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UnlimitedTimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public UnlimitedTimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UnlimitedTimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public UnlimitedTimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public ArrayListMultimap<JComponent, ValidatorField> createValidatorEditors() {
        ArrayListMultimap<JComponent, ValidatorField> editors = ArrayListMultimap.create();
        editors.put(getEditorPanel(), new ValidatorField( "validator",  "editorPanel",  "time"));
        return editors;
    }

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public ArrayListMultimap<JComponent, ValidatorField> getValidatorEditors() {
        return validatorEditors;
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setHours((Integer)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinutes((Integer)((JSpinner)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getEditorPanel() {
        return editorPanel;
    }

    public UnlimitedTimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerNumberModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JPanel getLeftPanel() {
        return leftPanel;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerNumberModel getMinuteModel() {
        return minuteModel;
    }

    public UnlimitedTimeEditorModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JLabel getTimeLabel() {
        return timeLabel;
    }

    public JToolBar getToolbarReset() {
        return toolbarReset;
    }

    public SwingValidator<UnlimitedTimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        editorPanel.add(hourEditor);
        editorPanel.add(labelH);
        editorPanel.add(minuteEditor);
        editorPanel.add(sliderHidorToolBar);
    }

    protected void addChildrenToLeftPanel() {
        leftPanel.add(timeLabel, BorderLayout.WEST);
        leftPanel.add(toolbarReset, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbarReset() {
        toolbarReset.add(reset);
    }

    protected void addChildrenToValidator() {
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditorPanel() {
        $objectMap.put("editorPanel", editorPanel = new JPanel());
        
        editorPanel.setName("editorPanel");
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerNumberModel(0, 0, 100, 1));
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setHorizontalAlignment(0);
        labelH.setText(t("TimeEditor.H"));
    }

    protected void createLeftPanel() {
        $objectMap.put("leftPanel", leftPanel = new JPanel());
        
        leftPanel.setName("leftPanel");
        leftPanel.setLayout(new BorderLayout());
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerNumberModel(0, 0, 59, 1));
    }

    protected void createModel() {
        $objectMap.put("model", model = new UnlimitedTimeEditorModel());
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setBorderPainted(false);
        reset.setOpaque(false);
        reset.setFocusable(false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFocusable(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeLabel() {
        $objectMap.put("timeLabel", timeLabel = new JLabel());
        
        timeLabel.setName("timeLabel");
    }

    protected void createToolbarReset() {
        $objectMap.put("toolbarReset", toolbarReset = new JToolBar());
        
        toolbarReset.setName("toolbarReset");
        toolbarReset.setBorderPainted(false);
        toolbarReset.setOpaque(false);
        toolbarReset.setFocusable(false);
        toolbarReset.setFloatable(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(UnlimitedTimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowReset();
        createValidator();
        createLeftPanel();
        createTimeLabel();
        createToolbarReset();
        createReset();
        createEditorPanel();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new UnlimitedTimeEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("hours", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(model.getHours());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("hours", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(model.getMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minutes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarReset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hourEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minuteEditor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(leftPanel, BorderLayout.WEST);
        add(SwingUtil.boxComponentWithJxLayer(editorPanel), BorderLayout.EAST);
        addChildrenToValidator();
        addChildrenToLeftPanel();
        addChildrenToToolbarReset();
        addChildrenToEditorPanel();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        UnlimitedTimeEditorResetAction.init(this, reset, new UnlimitedTimeEditorResetAction());
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 property setters
        hourEditor.setModel(hourModel);
        minuteEditor.setModel(minuteModel);// late initializer
        
        // register 1 validator(s)
        validatorIds = List.of("validator");
        // register 1 validator fields(s)
        validatorEditors = createValidatorEditors();
        installValidationUI();
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
