package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.ValidatorField;
import org.nuiton.jaxx.validator.swing.ui.ImageValidationUI;
import org.nuiton.jaxx.widgets.datetime.actions.TimeEditorResetAction;
import org.nuiton.jaxx.widgets.hidor.HidorButton;
import static io.ultreia.java4all.i18n.I18n.t;

public class TimeEditor extends JPanel implements BeanScopeAware, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_TIME_EDITOR_SLIDER = "showTimeEditorSlider";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_HIDOR_TARGET_VISIBLE = "sliderHidor.targetVisible";
    public static final String BINDING_SLIDER_VALUE = "slider.value";
    public static final String BINDING_TOOLBAR_RESET_VISIBLE = "toolbarReset.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWT1MbNxSXHWzAQIE0wyGTtp5AE5OStUnbXOi05e+YjAkZTJi0HFLZK7DoWruRtNiJJzn00Fu/QA+99tLJd8j00sz00ivfoTP5CH3S7np3YY3tlIPwPr339Hs/Pf2kP/5FGcHRks2PDeZSaTPjBLfbBneZpE1iPFh98mS3dkLqcoOIOqeOtDny/lJplD5EE2bXLiQyDiuQqehlKqpMRT9Tcd1uOjYjLJJopYJyQj63iGgQIiUq9AyuC1Gsdj1X2o7L/bUSUSet9ffPy2cpsvFrGqG2A/CvQdmfDZEgrHqkgtLUlOhq5QSf4qKF2TGA45QdQ0FTyrZuYSEe4iZ5hl6h0QrKOphDMonuvhc9Op1O1XYkGlt48AgzYpXkRfwtah4TKQwTS6IL2Ydh0wQH7jg6RVaiTNM2iSVRaYjoHRUSphhv2K5nk+iGqrhtiBYQYFQdyhjhG5DhXMhEkzLXtyrTbDh1TTTsVrhW1aIm4RLNqsSGotdYs22LYBYBoEL2iCBSGeYiE6cYwjGkgW48X2B3LkCrxoPAGCbJKQY8MLDN0fo86pXbeNc72JBl9f2xGm6EcBSPFVxTRMUTaaPy+qTrPCmhzBrmui6gJea/D3NrmMcjMtxz/TDmuuZKKFm5LFwAeS8BZE52ue/O3gln1V4HZMQx+butHJe6/llLVVZWX/PxmUmvBcKVSvH5q0LvfJmaNo+UeyuOZyLiJdFiryZuqHlDe4V8fBmiFH6Xxanzes/fX45u9RIIECQjFKRQG1KHsCcumCWa762FSs72wMsTsvneQqaW0Y4/vX7Ff2+9OwvUaxrA5ftFRYQapMThtgMFU4Vt2pMuV1KruIOdlUM4UMQCldcqfvty5FXfE9ADCu+UqkxGGYsGZMuMnr35c+6Hf66g9BbKWTY2t7Dy34bT0ICGbdiW2Xa++VaDm2yNwTijYMJeNGxOX9hMYmvVosesqUUzW4d/hLeBqtuXU9VF9nr33dvffvn0TUBXCoAuDBIZUpb5HmUpsygjWu59JU+U9wlHENe0Q5lOEm4Ep1VSaRHH15k1PW5d4CEt0VQdW4SZmG9RYsFNM9dZ9w1Geffx3tPdracbq9+9hIygaC7031KngZlpEW5A75cDbT5QkwWt9squFLawuPiy7aqFH2ha1K8Kigr6APCCC2Si040CLKOE4ZpFAO5Uh4pN76OQvFxEUwZY79K2kGhEkjZ8T4Y3iFFOWtQXpvfgfzbkf2f74eP9zQj1RpT6nfCOG4L86NU4BP1TnUjckBsQk+J+a16BjDWbgzA+whQ4hxUyR9iCmwdlbQc/UzQEhvEjOPBSLR3YkpZPUPp+IEYAhMQcqDyggur816HMasLTAWoGNrxHBTyYFjqycDPSHCBGFDRAzRsejps6AG4MclmAmo8GZD04cLd2PGvy5kZK7VfjGLg7imL9OBCqtbkiN6eN+7T+Y2gbP4IDcVfQF/A7vbws0UwTnwCb4FR1cB1uM7DfL0Weex1GWvkNcoRdS67ZLjOJuQePK69/CqWl/PJSHsb7pfyd/L0vVIUz0CXnU35eCnv/eifW39vM63/hbcAQ7ejfxv34Semy667o11/DkH5Jd4+eBq027beafprp8gZr9NiTbgAkF8vrTSRk197nYCfB8N6JA9ALGvnchucS+uAreAPjfI0yE/b96wtJU2rM9c2ozH+p4W1yho/+d4Y8ZPgPKiJDWcYOAAA=";
    private static final Logger log = LogManager.getLogger(TimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel dateEditor;
    protected TimeEditorHandler handler;
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected TimeEditorModel model;
    protected JButton reset;
    protected Boolean showReset;
    protected Boolean showTimeEditorSlider;
    protected JSlider slider;
    protected HidorButton sliderHidor;
    protected JToolBar sliderHidorToolBar;
    protected JPanel timeEditor;
    protected JLabel timeLabel;
    protected JToolBar toolbarReset;
    protected SwingValidator<TimeEditorModel> validator;
    protected ArrayListMultimap<JComponent, ValidatorField> validatorEditors;
    protected List<String> validatorIds;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditor $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setPropertyTime(String property) { model.setPropertyTime(property); }
    public void setTime(Date time) { model.setTime(time); }
    
    public void setLabel(String label) { timeLabel.setText(label); }
    
    public void reset() { handler.reset(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditor() {
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public ArrayListMultimap<JComponent, ValidatorField> createValidatorEditors() {
        ArrayListMultimap<JComponent, ValidatorField> editors = ArrayListMultimap.create();
        editors.put(getTimeEditor(), new ValidatorField( "validator",  "timeEditor",  "time"));
        return editors;
    }

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public ArrayListMultimap<JComponent, ValidatorField> getValidatorEditors() {
        return validatorEditors;
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public TimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public TimeEditorModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public Boolean getShowTimeEditorSlider() {
        return showTimeEditorSlider;
    }

    public JSlider getSlider() {
        return slider;
    }

    public HidorButton getSliderHidor() {
        return sliderHidor;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JPanel getTimeEditor() {
        return timeEditor;
    }

    public JLabel getTimeLabel() {
        return timeLabel;
    }

    public JToolBar getToolbarReset() {
        return toolbarReset;
    }

    public SwingValidator<TimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isShowTimeEditorSlider() {
        return showTimeEditorSlider !=null && showTimeEditorSlider;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowTimeEditorSlider(Boolean showTimeEditorSlider) {
        Boolean oldValue = this.showTimeEditorSlider;
        this.showTimeEditorSlider = showTimeEditorSlider;
        firePropertyChange(PROPERTY_SHOW_TIME_EDITOR_SLIDER, oldValue, showTimeEditorSlider);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected accessors methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        dateEditor.add($JPanel1, BorderLayout.CENTER);
        dateEditor.add($JPanel2, BorderLayout.EAST);
    }

    protected void addChildrenToSliderHidorToolBar() {
        sliderHidorToolBar.add(sliderHidor);
    }

    protected void addChildrenToTimeEditor() {
        timeEditor.add(hourEditor);
        timeEditor.add(labelH);
        timeEditor.add(minuteEditor);
    }

    protected void addChildrenToToolbarReset() {
        toolbarReset.add(reset);
    }

    protected void addChildrenToValidator() {
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setHorizontalAlignment(0);
        labelH.setText(t("TimeEditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new TimeEditorModel());
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusable(false);
        reset.setFocusPainted(false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowTimeEditorSlider() {
        $objectMap.put("showTimeEditorSlider", showTimeEditorSlider = true);
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createSliderHidor() {
        $objectMap.put("sliderHidor", sliderHidor = new HidorButton());
        
        sliderHidor.setName("sliderHidor");
        sliderHidor.setFocusable(false);
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeEditor() {
        $objectMap.put("timeEditor", timeEditor = new JPanel());
        
        timeEditor.setName("timeEditor");
    }

    protected void createTimeLabel() {
        $objectMap.put("timeLabel", timeLabel = new JLabel());
        
        timeLabel.setName("timeLabel");
    }

    protected void createToolbarReset() {
        $objectMap.put("toolbarReset", toolbarReset = new JToolBar());
        
        toolbarReset.setName("toolbarReset");
        toolbarReset.setBorderPainted(false);
        toolbarReset.setFloatable(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(TimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowTimeEditorSlider();
        createShowReset();
        createValidator();
        createDateEditor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createTimeLabel();
        createToolbarReset();
        createReset();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        createTimeEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        createSliderHidor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new TimeEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarReset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hourEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minuteEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_HIDOR_TARGET_VISIBLE, true ,"showTimeEditorSlider") {
        
            @Override
            public void processDataBinding() {
                sliderHidor.setTargetVisible(isShowTimeEditorSlider());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(dateEditor, BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(timeLabel, BorderLayout.WEST);
        $JPanel1.add(toolbarReset, BorderLayout.EAST);
        addChildrenToToolbarReset();
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(timeEditor));
        $JPanel2.add(sliderHidorToolBar);
        addChildrenToTimeEditor();
        addChildrenToSliderHidorToolBar();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        TimeEditorResetAction.init(this, reset, new TimeEditorResetAction());
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 11 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        hourEditor.setModel(hourModel);
        minuteEditor.setModel(minuteModel);
        sliderHidor.setShowTip(t("TimeEditor.action.show.slider"));
        sliderHidor.setHideTip(t("TimeEditor.action.hide.slider"));
        sliderHidor.setTarget(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));// late initializer
        
        // register 1 validator(s)
        validatorIds = List.of("validator");
        // register 1 validator fields(s)
        validatorEditors = createValidatorEditors();
        installValidationUI();
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
