package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.datetime.actions.DateEditorResetAction;

public class DateEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_EDITOR_DATE = "dateEditor.date";
    public static final String BINDING_DATE_EDITOR_ENABLED = "dateEditor.enabled";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_TOOLBAR_RESET_VISIBLE = "toolbarReset.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uy27TQBS9SZukSR/QglhHbelDFLusi3j0JYgSWrUsKrJhEk+SSR2PmRk3jiq6YMGOH2DBlg3qP1SskNiw7T8g9RO4Yydx2iZ9YCmWMz5z5txzz/WPv5CQApa4qBqOxxR3jDrxfUN4jmINauRe7u1tleq0rNapLAvmKi4gvGJxiBdh1OquSwVGMY9MZshkaiazzWSu8YbLHer0EK3kISNVy6ayRqlSsDBwc1lKc7eLXPFdT7TP6qu631m/Pz85jdH1r3EA30X5SSz70S0IoqqH8xBnloKpfJ0cENMmThXFCeZUsaBxvbZmEynfkAb9AEeQykPSJQLJFDz+L3sCuoDKdxWMzOa2iUPtZXVZf5NZVaqkYRFFg0LW8WHDQoBw3YAiqSDR4Ba1FSzfYndBb4ko0rLGmztU6q5N6ooN7YKxyrlNiRPhxhSulIhoQ+9rqG/IJnpl5N7iu1UiNDQdiRMh9N456KqnUKWGTHWRGaurTkFW11LHLO4r7oa7fCO3pwvYZuV92jlFwNygnmPGjChjUbtjRRTl4bKCmcHx1gndQVSYzZnB2dTHBMBPx0fie/PstBPIYRSXvW5Xz+xhOlzBXSoU09ruhGn0FLPNAnFXitgkauPgBoM5f7Xy3TYS1aOKsKOayXhFZA3ZEqnTk58P3v8ZgvgmZGxOrE2i8a8hrWrYsRq3Ld99/iIQN9Ycwftd/A0pGA7CBJOHQegMzJfuycLiRwWpChcNolDdxOG0ZZmFgtnCa1q/og4p2RSHbOaQyY3wz8Jidm4uG/LgInZeLyOVj47PX+14t8DjrbNf3748POm4HsN6Z2+yM3I+8Q6SzLGZQ4MPQXvG+w7+qCupZ/FogPuNNJzLstuenmxwn+3n6XiJC4uKbcIcpT1KVIiNQwOpAyYZWoJhQNd2OyMamJ2uYNcCwzp439MHLAUe6CcDLszrDZSkK7zsyV7W3t6N9/YONYwF6Auy+8kIPwLXnR9TkLRJi+O3ASaeooMkW2KOhaP/7BJpTN8zyPgPOBAoYPEGAAA=";
    private static final Logger log = LogManager.getLogger(DateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker dateEditor;
    protected DateEditorHandler handler;
    protected DateEditorModel model;
    protected JButton reset;
    protected Boolean showReset;
    protected JToolBar toolbarReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateEditor $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setProperty(String property) { model.setProperty(property); }
    public void setEditable(boolean editable) { model.setEditable(editable); }
    public void setDate(Date date) { model.setDate(date); }
    
    public void setDateFormat(String dateFormat) { dateEditor.setFormats(dateFormat); }
    public void reset() { model.reset(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateEditor() {
        $initialize();
    }

    public DateEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__dateEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDate((Date)((JXDatePicker)event.getSource()).getDate());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getDateEditor() {
        return dateEditor;
    }

    public DateEditorHandler getHandler() {
        return handler;
    }

    public DateEditorModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JToolBar getToolbarReset() {
        return toolbarReset;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbarReset() {
        toolbarReset.add(reset);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JXDatePicker());
        
        dateEditor.setName("dateEditor");
        dateEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dateEditor"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateEditorModel());
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusable(false);
        reset.setFocusPainted(false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createToolbarReset() {
        $objectMap.put("toolbarReset", toolbarReset = new JToolBar());
        
        toolbarReset.setName("toolbarReset");
        toolbarReset.setBorderPainted(false);
        toolbarReset.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createShowReset();
        createToolbarReset();
        createReset();
        createDateEditor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new DateEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarReset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dateEditor.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dateEditor.setEnabled(isEnabled() && model.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbarReset, BorderLayout.WEST);
        add(dateEditor, BorderLayout.CENTER);
        addChildrenToToolbarReset();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        DateEditorResetAction.init(this, reset, new DateEditorResetAction());
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        dateEditor.setFormats("dd/MM/yyyy");
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
