package io.ultreia.java4all.jaxx.widgets.list;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListAddAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListDisplayDecoratorAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListRemoveAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListResetAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListResetFilterAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListSelectedListMoveDownAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListSelectedListMoveUpAction;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.t;

public class DoubleList<O> extends Table implements BeanTypeAware<O>, BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_HIGHLIGHT_FILTER_TEXT = "highlightFilterText";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_SELECT_POPUP_ENABLED = "showSelectPopupEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ACTION_ENABLED = "addAction.enabled";
    public static final String BINDING_DISPLAY_DECORATOR_ENABLED = "displayDecorator.enabled";
    public static final String BINDING_DISPLAY_DECORATOR_VISIBLE = "displayDecorator.visible";
    public static final String BINDING_REMOVE_ACTION_ENABLED = "removeAction.enabled";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_RESET_VISIBLE = "reset.visible";
    public static final String BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU = "selectedList.componentPopupMenu";
    public static final String BINDING_SELECTED_LIST_ENABLED = "selectedList.enabled";
    public static final String BINDING_SELECTED_LIST_MODEL = "selectedList.model";
    public static final String BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED = "selectedListMoveDownAction.enabled";
    public static final String BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED = "selectedListMoveUpAction.enabled";
    public static final String BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED = "selectedListRemoveAction.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOP_PANEL_VISIBLE = "topPanel.visible";
    public static final String BINDING_UNIVERSE_LIST_ENABLED = "universeList.enabled";
    public static final String BINDING_UNIVERSE_LIST_MODEL = "universeList.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(DoubleList.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAction;
    protected JPanel beforeFilterPanel;
    protected JToggleButton displayDecorator;
    protected JTextField filterField;
    protected JLabel filterFieldLabel;
    protected Boolean filterable;
    protected DoubleListHandler<O> handler;
    protected Boolean highlightFilterText;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected DoubleListModel<O> model;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected JButton removeAction;
    protected JButton reset;
    protected JButton resetFilter;
    protected Boolean reverseSort;
    protected JPanel selectedHeader;
    protected JLabel selectedHeaderLabel;
    protected JList<O> selectedList;
    protected JMenuItem selectedListMoveDownAction;
    protected JMenuItem selectedListMoveUpAction;
    protected JScrollPane selectedListPane;
    protected JPopupMenu selectedListPopup;
    protected JMenuItem selectedListRemoveAction;
    protected JToolBar selectedToolbar;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected Boolean showSelectPopupEnabled;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbarLeft;
    protected JPanel topPanel;
    protected JPanel universeHeader;
    protected JLabel universeHeaderLabel;
    protected JList<O> universeList;
    protected JScrollPane universeListPane;
    protected JToolBar universeToolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private DoubleList<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Decorator decorator, List<O> universe, List<O> selected) {
        handler.init(decorator, universe, selected);
    }
    
    public Class<O> getBeanType() { return model.getConfig().getBeanType(); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    // Config delegate methods
    public void setBeanType(Class<O> beanType) { model.getConfig().setBeanType(beanType); }
    public void setProperty(String property) { model.getConfig().setProperty(property); }
    public void setUseMultiSelect(boolean useMultiSelect) { model.getConfig().setUseMultiSelect(useMultiSelect); }
    public void setI18nPrefix(String i18nPrefix) { model.getConfig().setI18nPrefix(i18nPrefix); }
    public void setShowListLabel(boolean showListLabel) { model.getConfig().setShowListLabel(showListLabel); }
    public void setLabel(String label) { model.getConfig().setLabel(label); }
    public void setUniverseLabel(String universeLabel) { model.getConfig().setUniverseLabel(universeLabel); }
    public void setSelectedLabel(String selectedLabel) { model.getConfig().setSelectedLabel(selectedLabel); }
    public void setAutoSortSelectedList(boolean autoSortSelectedList) { model.getConfig().setAutoSortSelectedList(autoSortSelectedList); }
    
    // Model delegate methods
    public void setUniverse(java.util.List<O> universe) { handler.setUniverse(universe);}
    public void setSelected(java.util.List<O> selected) { handler.setSelected(selected);}

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DoubleList() {
        $initialize();
    }

    public DoubleList(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__selectedList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListFocusGained(event);
    }

    public void doFocusGained__on__universeList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListFocusGained(event);
    }

    public void doMouseClicked__on__selectedList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListClicked(event);
    }

    public void doMouseClicked__on__universeList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListClicked(event);
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displayDecorator.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displayDecorator.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAction() {
        return addAction;
    }

    public JPanel getBeforeFilterPanel() {
        return beforeFilterPanel;
    }

    public JToggleButton getDisplayDecorator() {
        return displayDecorator;
    }

    public JTextField getFilterField() {
        return filterField;
    }

    public JLabel getFilterFieldLabel() {
        return filterFieldLabel;
    }

    public Boolean getFilterable() {
        return filterable;
    }

    public DoubleListHandler<O> getHandler() {
        return handler;
    }

    public Boolean getHighlightFilterText() {
        return highlightFilterText;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public DoubleListModel<O> getModel() {
        return model;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public JButton getRemoveAction() {
        return removeAction;
    }

    public JButton getReset() {
        return reset;
    }

    public JButton getResetFilter() {
        return resetFilter;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public JPanel getSelectedHeader() {
        return selectedHeader;
    }

    public JLabel getSelectedHeaderLabel() {
        return selectedHeaderLabel;
    }

    public JList<O> getSelectedList() {
        return selectedList;
    }

    public JMenuItem getSelectedListMoveDownAction() {
        return selectedListMoveDownAction;
    }

    public JMenuItem getSelectedListMoveUpAction() {
        return selectedListMoveUpAction;
    }

    public JScrollPane getSelectedListPane() {
        return selectedListPane;
    }

    public JPopupMenu getSelectedListPopup() {
        return selectedListPopup;
    }

    public JMenuItem getSelectedListRemoveAction() {
        return selectedListRemoveAction;
    }

    public JToolBar getSelectedToolbar() {
        return selectedToolbar;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public Boolean getShowSelectPopupEnabled() {
        return showSelectPopupEnabled;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JPanel getTopPanel() {
        return topPanel;
    }

    public JPanel getUniverseHeader() {
        return universeHeader;
    }

    public JLabel getUniverseHeaderLabel() {
        return universeHeaderLabel;
    }

    public JList<O> getUniverseList() {
        return universeList;
    }

    public JScrollPane getUniverseListPane() {
        return universeListPane;
    }

    public JToolBar getUniverseToolbar() {
        return universeToolbar;
    }

    public Boolean isFilterable() {
        return filterable !=null && filterable;
    }

    public Boolean isHighlightFilterText() {
        return highlightFilterText !=null && highlightFilterText;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isShowSelectPopupEnabled() {
        return showSelectPopupEnabled !=null && showSelectPopupEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFilterable(Boolean filterable) {
        Boolean oldValue = this.filterable;
        this.filterable = filterable;
        firePropertyChange(PROPERTY_FILTERABLE, oldValue, filterable);
    }

    public void setHighlightFilterText(Boolean highlightFilterText) {
        Boolean oldValue = this.highlightFilterText;
        this.highlightFilterText = highlightFilterText;
        firePropertyChange(PROPERTY_HIGHLIGHT_FILTER_TEXT, oldValue, highlightFilterText);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowSelectPopupEnabled(Boolean showSelectPopupEnabled) {
        Boolean oldValue = this.showSelectPopupEnabled;
        this.showSelectPopupEnabled = showSelectPopupEnabled;
        firePropertyChange(PROPERTY_SHOW_SELECT_POPUP_ENABLED, oldValue, showSelectPopupEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected accessors methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSelectedHeader() {
        selectedHeader.add(selectedHeaderLabel, BorderLayout.WEST);
        selectedHeader.add(selectedToolbar, BorderLayout.EAST);
    }

    protected void addChildrenToSelectedListPane() {
        selectedListPane.getViewport().add(selectedList);
    }

    protected void addChildrenToSelectedListPopup() {
        selectedListPopup.add(selectedListMoveUpAction);
        selectedListPopup.add(selectedListMoveDownAction);
        selectedListPopup.add(selectedListRemoveAction);
    }

    protected void addChildrenToSelectedToolbar() {
        selectedToolbar.add(removeAction);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetFilter);
    }

    protected void addChildrenToTopPanel() {
        topPanel.add($JPanel0, BorderLayout.WEST);
        topPanel.add(filterField, BorderLayout.CENTER);
    }

    protected void addChildrenToUniverseHeader() {
        universeHeader.add(universeHeaderLabel, BorderLayout.WEST);
        universeHeader.add(universeToolbar, BorderLayout.EAST);
    }

    protected void addChildrenToUniverseListPane() {
        universeListPane.getViewport().add(universeList);
    }

    protected void addChildrenToUniverseToolbar() {
        universeToolbar.add(displayDecorator);
        universeToolbar.add(reset);
        universeToolbar.add(addAction);
    }

    protected void createAddAction() {
        $objectMap.put("addAction", addAction = new JButton());
        
        addAction.setName("addAction");
        addAction.setBorderPainted(false);
        addAction.setFocusable(false);
    }

    protected void createBeforeFilterPanel() {
        $objectMap.put("beforeFilterPanel", beforeFilterPanel = new JPanel());
        
        beforeFilterPanel.setName("beforeFilterPanel");
        beforeFilterPanel.setLayout(new BorderLayout());
    }

    protected void createDisplayDecorator() {
        $objectMap.put("displayDecorator", displayDecorator = new JToggleButton());
        
        displayDecorator.setName("displayDecorator");
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterFieldLabel() {
        $objectMap.put("filterFieldLabel", filterFieldLabel = new JLabel());
        
        filterFieldLabel.setName("filterFieldLabel");
    }

    protected void createFilterable() {
        $objectMap.put("filterable", filterable = true);
    }

    protected void createHighlightFilterText() {
        $objectMap.put("highlightFilterText", highlightFilterText = false);
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DoubleListModel.class));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createRemoveAction() {
        $objectMap.put("removeAction", removeAction = new JButton());
        
        removeAction.setName("removeAction");
        removeAction.setBorderPainted(false);
        removeAction.setFocusable(false);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setBorderPainted(false);
        reset.setFocusable(false);
    }

    protected void createResetFilter() {
        $objectMap.put("resetFilter", resetFilter = new JButton());
        
        resetFilter.setName("resetFilter");
        resetFilter.setBorderPainted(false);
        resetFilter.setFocusable(false);
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedHeader() {
        $objectMap.put("selectedHeader", selectedHeader = new JPanel());
        
        selectedHeader.setName("selectedHeader");
        selectedHeader.setLayout(new BorderLayout());
    }

    protected void createSelectedHeaderLabel() {
        $objectMap.put("selectedHeaderLabel", selectedHeaderLabel = new JLabel());
        
        selectedHeaderLabel.setName("selectedHeaderLabel");
    }

    protected void createSelectedList() {
        $objectMap.put("selectedList", selectedList = new JList<O>());
        
        selectedList.setName("selectedList");
        selectedList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__selectedList"));
        selectedList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedList"));
    }

    protected void createSelectedListMoveDownAction() {
        $objectMap.put("selectedListMoveDownAction", selectedListMoveDownAction = new JMenuItem());
        
        selectedListMoveDownAction.setName("selectedListMoveDownAction");
    }

    protected void createSelectedListMoveUpAction() {
        $objectMap.put("selectedListMoveUpAction", selectedListMoveUpAction = new JMenuItem());
        
        selectedListMoveUpAction.setName("selectedListMoveUpAction");
    }

    protected void createSelectedListPane() {
        $objectMap.put("selectedListPane", selectedListPane = new JScrollPane());
        
        selectedListPane.setName("selectedListPane");
    }

    protected void createSelectedListPopup() {
        $objectMap.put("selectedListPopup", selectedListPopup = new JPopupMenu());
        
        selectedListPopup.setName("selectedListPopup");
    }

    protected void createSelectedListRemoveAction() {
        $objectMap.put("selectedListRemoveAction", selectedListRemoveAction = new JMenuItem());
        
        selectedListRemoveAction.setName("selectedListRemoveAction");
        selectedListRemoveAction.setText(t("bean.action.selected.remove"));
    }

    protected void createSelectedToolbar() {
        $objectMap.put("selectedToolbar", selectedToolbar = new JToolBar());
        
        selectedToolbar.setName("selectedToolbar");
        selectedToolbar.setBorderPainted(false);
        selectedToolbar.setFocusable(false);
        selectedToolbar.setFloatable(false);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = true);
    }

    protected void createShowSelectPopupEnabled() {
        $objectMap.put("showSelectPopupEnabled", showSelectPopupEnabled = true);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFocusable(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new JPanel());
        
        topPanel.setName("topPanel");
        topPanel.setLayout(new BorderLayout());
    }

    protected void createUniverseHeader() {
        $objectMap.put("universeHeader", universeHeader = new JPanel());
        
        universeHeader.setName("universeHeader");
        universeHeader.setLayout(new BorderLayout());
    }

    protected void createUniverseHeaderLabel() {
        $objectMap.put("universeHeaderLabel", universeHeaderLabel = new JLabel());
        
        universeHeaderLabel.setName("universeHeaderLabel");
    }

    protected void createUniverseList() {
        $objectMap.put("universeList", universeList = new JList<O>());
        
        universeList.setName("universeList");
        universeList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__universeList"));
        universeList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__universeList"));
    }

    protected void createUniverseListPane() {
        $objectMap.put("universeListPane", universeListPane = new JScrollPane());
        
        universeListPane.setName("universeListPane");
    }

    protected void createUniverseToolbar() {
        $objectMap.put("universeToolbar", universeToolbar = new JToolBar());
        
        universeToolbar.setName("universeToolbar");
        universeToolbar.setBorderPainted(false);
        universeToolbar.setFocusable(false);
        universeToolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createFilterable();
        createShowDecorator();
        createShowReset();
        createShowSelectPopupEnabled();
        createHighlightFilterText();
        createModel();
        createReverseSort();
        createIndex();
        createIndexes();
        createSortGroup();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSelectedListPopup();
        createSelectedListMoveUpAction();
        createSelectedListMoveDownAction();
        createSelectedListRemoveAction();
        createBeforeFilterPanel();
        createTopPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createToolbarLeft();
        createResetFilter();
        createFilterFieldLabel();
        createFilterField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createUniverseListPane();
        createUniverseList();
        createUniverseHeader();
        createUniverseHeaderLabel();
        createUniverseToolbar();
        createDisplayDecorator();
        createReset();
        createAddAction();
        createSelectedListPane();
        createSelectedList();
        createSelectedHeader();
        createSelectedHeaderLabel();
        createSelectedToolbar();
        createRemoveAction();
        // inline creation of $Table0
        setName("$Table0");
    }

    protected DoubleListHandler $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new DoubleListHandler<>();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedUpEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveUpAction.setEnabled(model.isSelectedUpEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedUpEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedDownEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveDownAction.setEnabled(model.isSelectedDownEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedDownEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListRemoveAction.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOP_PANEL_VISIBLE, true ,"filterable") {
        
            @Override
            public void processDataBinding() {
                topPanel.setVisible(isFilterable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNIVERSE_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("universeModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    universeList.setModel(model.getUniverseModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("universeModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UNIVERSE_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                universeList.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISPLAY_DECORATOR_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                displayDecorator.setVisible(isShowDecorator());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISPLAY_DECORATOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                displayDecorator.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                reset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addAction.setEnabled(model.isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU, true ,"showSelectPopupEnabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setComponentPopupMenu(handler.getSelectedListPopup(isShowSelectPopupEnabled()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedList.setModel(model.getSelectedModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAction.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(beforeFilterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToSelectedListPopup();
        addChildrenToTopPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(toolbarLeft, BorderLayout.WEST);
        $JPanel0.add(filterFieldLabel, BorderLayout.WEST);
        addChildrenToToolbarLeft();
        // inline complete setup of $JPanel1
        $JPanel1.add(universeListPane);
        $JPanel1.add(universeHeader);
        $JPanel1.add(selectedListPane);
        addChildrenToUniverseListPane();
        addChildrenToUniverseHeader();
        addChildrenToUniverseToolbar();
        addChildrenToSelectedListPane();
        addChildrenToSelectedHeader();
        addChildrenToSelectedToolbar();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        DoubleListSelectedListMoveUpAction.init(this, selectedListMoveUpAction, new DoubleListSelectedListMoveUpAction<>());
        DoubleListSelectedListMoveDownAction.init(this, selectedListMoveDownAction, new DoubleListSelectedListMoveDownAction<>());
        DoubleListResetFilterAction.init(this, resetFilter, new DoubleListResetFilterAction<>());
        DoubleListDisplayDecoratorAction.init(this, displayDecorator, new DoubleListDisplayDecoratorAction<>());
        DoubleListResetAction.init(this, reset, new DoubleListResetAction<>());
        DoubleListAddAction.init(this, addAction, new DoubleListAddAction<>());
        DoubleListRemoveAction.init(this, removeAction, new DoubleListRemoveAction<>());
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 19 property setters
        universeListPane.setColumnHeaderView(universeHeader);
        selectedListPane.setColumnHeaderView(selectedHeader);
        popup.setBorder(new TitledBorder(t("beandoublelist.popup.title") + "      "));
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterFieldLabel.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-filter"));
        universeListPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        universeListPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        selectedListPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        selectedListPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
