package io.ultreia.java4all.jaxx.widgets.length.nautical;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class NauticalLengthEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_NUMBER_VALUE = "editor.numberValue";
    public static final String BINDING_FTM_SELECTED = "FTM.selected";
    public static final String BINDING_KM_SELECTED = "KM.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";
    public static final String BINDING_M_SELECTED = "M.selected";
    public static final String BINDING_NM_SELECTED = "NM.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UTW9bRRQdu3W+3PBRJD4EC0tN2rTAGKQsEKGAm9hpwrNj2S9RIYsw9ps4E41nhnnzmhdZdMGCHX+ABVs2qP+hYoXEhm3+A1J/AnfmPdsx8UugqiU/P13fe+bOueee3/5GhVCjD6TuYRExIwU+JnGMdSQM61O8XXn0aKdzTLtmg4ZdzZSRGiWfXB7l91ExGMVDg/C+B0jlBKlskcopUnld9pUUVJwDWvPQQmhOOQ2PKDUGrWQWd8Ow3B5lrsUq0ulZU7uedtafP358lqMbP+cRihW0Pw/Xfv9/AIxvfd1DeRYYdNM7Jo9JmRPRg+Y0Ez240KKNrXMShg3Sp9+hJ2jWQzOKaAAz6MMXosfBOahYGTS3tN0kgvKPDKoyiSNuNGUE23NXCefJRU5Y0KMmxJyKnjnCgkSGdQnHjfTFc/FqAI1opRz4jEGFvgwoN2j7peDWLdgYfIa6qLnI+hBURP0O1bjhfhIMWzs/gigeSt0nxl0f+LetxTg8AeZxwslkeq5u0NsTSS0SMPkgMnC0zbk5Ss1/Vbdvb/0r2pgWvVbzp4XnkuYebMKYs3SVtgFLlTSxqWWkgCKNbmeVgPTxWPpjFeb2UUFHEDboVvbW2cVpQVayMreyV8Ye4xJ/ePpE/3ry/Gy4J9YeSldVnbMEEK3SUlFtmO3t1WRJQB28XCdqbR8Wj3LwE+cXdy7vvJ1mQvfQxesWCVsk/JCER4BWmD179vub3/51DeVraIFLEtSIzd9C8+ZIA2OSB7H64kvX3I2TOXi+Bl+rpM6Y/4nRzR/KbhSSDgeuC4eEh/B73dAYlndpMKnymivCy8sY1OuRDuUrd7+HqseER1D1TlY65BSNlNxnynfA9y4DHvoBk8LBzyX0UTAgnFVXun+/5FbZAiRRqI1BAXcuV8CI8Kc7z//45aflZ0MV5ID/pf9SOVZC4Rs0wwRngjq/TK1wqj8WVUijQI59bprzIRjUjfMbnFrLbfe8d2HKObCcZK4GrQ5WplF1tzQcvCWqnRK7Z+fn+LLAn7jb27dP0dAh1RVHFwxaSMzMP1UghcVBDcRpcNdeB2a4mPzZhNaoFga9N2hbY9i10t6orm/VK97qQbPi+9VWw448XahTe5FMp8XN1k6z2vK/PmhUdv2t9Yp34FUbm/5DQJiNQtpmPTHWdDFpYS/R6ruDkVwm8TNoSL38Kh7sCDg5lTAu9MpnATGk1GEigKt+fgE1Z58LVyLa8K597E1HeAMQ/gEWqeny1QgAAA==";
    private static final Logger log = LogManager.getLogger(NauticalLengthEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton FTM;
    protected JRadioButton KM;
    protected JRadioButton M;
    protected JRadioButton NM;
    protected NumberEditor editor;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected NauticalLengthEditorHandler handler;
    protected NauticalLengthEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NauticalLengthEditor $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JLabel label) { handler.init(this, label); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    public void setConfig(NauticalLengthEditorConfig config) { model.setConfig(config); }
    public void setStorageNauticalLength(Float nauticalLength) { model.setStorageNauticalLength(nauticalLength); }
    public void setNauticalLength(Float nauticalLength) { model.setNauticalLength(nauticalLength); }
    public void setFormat(NauticalLengthFormat format) { model.setFormat(format); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NauticalLengthEditor() {
        $initialize();
    }

    public NauticalLengthEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NauticalLengthEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NauticalLengthEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NauticalLengthEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NauticalLengthEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NauticalLengthEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NauticalLengthEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getEditor() {
        return editor;
    }

    public JRadioButton getFTM() {
        return FTM;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public NauticalLengthEditorHandler getHandler() {
        return handler;
    }

    public JRadioButton getKM() {
        return KM;
    }

    public JRadioButton getM() {
        return M;
    }

    public NauticalLengthEditorModel getModel() {
        return model;
    }

    public JRadioButton getNM() {
        return NM;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFTM() {
        { ButtonGroup $buttonGroup = formatBG; FTM.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(FTM); }
    }

    protected void addChildrenToFormatPanel() {
        formatPanel.add(M);
        formatPanel.add(KM);
        formatPanel.add(NM);
        formatPanel.add(FTM);
    }

    protected void addChildrenToKM() {
        { ButtonGroup $buttonGroup = formatBG; KM.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(KM); }
    }

    protected void addChildrenToM() {
        { ButtonGroup $buttonGroup = formatBG; M.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(M); }
    }

    protected void addChildrenToNM() {
        { ButtonGroup $buttonGroup = formatBG; NM.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(NM); }
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
    }

    protected void createFTM() {
        $objectMap.put("FTM", FTM = new JRadioButton());
        
        FTM.setName("FTM");
        FTM.setFocusable(false);
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(1, 0, 2, 0));
    }

    protected void createKM() {
        $objectMap.put("KM", KM = new JRadioButton());
        
        KM.setName("KM");
        KM.setFocusable(false);
    }

    protected void createM() {
        $objectMap.put("M", M = new JRadioButton());
        
        M.setName("M");
        M.setFocusable(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NauticalLengthEditorModel.class));
    }

    protected void createNM() {
        $objectMap.put("NM", NM = new JRadioButton());
        
        NM.setName("NM");
        NM.setFocusable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createEditor();
        createFormatPanel();
        createM();
        createKM();
        createNM();
        createFTM();
        createFormatBG();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected UIHandler<? extends JAXXObject> $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new NauticalLengthEditorHandler();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((NauticalLengthFormat) formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nauticalLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setNumberValue(model.getNauticalLength());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nauticalLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_M_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    M.setSelected(NauticalLengthFormat.M == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_KM_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    KM.setSelected(NauticalLengthFormat.KM == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NM_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    NM.setSelected(NauticalLengthFormat.NM == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FTM_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    FTM.setSelected(NauticalLengthFormat.FTM == model.getFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(editor, BorderLayout.CENTER);
        add(formatPanel, BorderLayout.EAST);
        addChildrenToFormatPanel();
        addChildrenToM();
        addChildrenToKM();
        addChildrenToNM();
        addChildrenToFTM();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 17 property setters
        editor.setNumberType(Float.class);
        editor.setNumberPattern(SwingUtil.DECIMAL4_PATTERN);
        editor.setProperty(NauticalLengthEditorModel.PROPERTY_NAUTICAL_LENGTH);
        M.setText(NauticalLengthFormat.M.getLabel());
        { M.putClientProperty("$value", NauticalLengthFormat.M);  Object $buttonGroup = M.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        M.setToolTipText(NauticalLengthFormat.M.getDescription());
        KM.setText(NauticalLengthFormat.KM.getLabel());
        { KM.putClientProperty("$value", NauticalLengthFormat.KM);  Object $buttonGroup = KM.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        KM.setToolTipText(NauticalLengthFormat.KM.getDescription());
        NM.setText(NauticalLengthFormat.NM.getLabel());
        { NM.putClientProperty("$value", NauticalLengthFormat.NM);  Object $buttonGroup = NM.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        NM.setToolTipText(NauticalLengthFormat.NM.getDescription());
        FTM.setText(NauticalLengthFormat.FTM.getLabel());
        { FTM.putClientProperty("$value", NauticalLengthFormat.FTM);  Object $buttonGroup = FTM.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        FTM.setToolTipText(NauticalLengthFormat.FTM.getDescription());
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
