package io.ultreia.java4all.jaxx.widgets.combobox;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.combobox.actions.FilterableComboBoxDisplayDecorator;
import io.ultreia.java4all.jaxx.widgets.combobox.actions.FilterableComboBoxReset;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.t;

public class FilterableComboBox<O extends JavaBean> extends Table implements BeanTypeAware<O>, BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";
    public static final String BINDING_DISPLAY_DECORATOR_ENABLED = "displayDecorator.enabled";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";
    public static final String BINDING_TOOLBAR_RIGHT_VISIBLE = "toolbarRight.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wy3IbRRRtK5b8kp0HITwLFEdx7DIeBQpWdkFiG4MpmaRsh0rhDS1NW2pXa3qY7rEmpXIWLNjxAyzYsqHyA7BJsaKKDVv/A1X5BO7tGak19shycLRQSbdvn3vuY86d3/4leRWQD2TQcLyQa+k5BzSKnCD0NG8x56v7jx8/qB2wul5nqh5wX8uAxJ+RHMntkSm3Z1eaOHtVQKrESBVEqiRIlTXZ8qXHvD6g5SqZVPqJYKrJmNZkfuDlulKVnZ7ncuSHQRIrk3VWrL9//PB4hK3/nCMk8oH+VUh78SUAbNajVZLjribXqgf0kFYE9RpALuBeAxKaRtuaoEp9TVvse/KUjFVJwacBgGmy9L/KY+AMVORrMlbepTXB7mqywqUTCh0wTh0M+zEVIs6jzd0G08qpy1ZN1mTkbHChWYD31tC0KiPfN5AFTQp16e3zhiarF8FbMyAWNd+SLhOa3L8I6BZiWMwx7rksYjBoS4M6p9rQBzO2q6GG0y8CGfoWYULJQBsbGq730fWlH0J1byDHqAvzEI1bzAut44xx3AGYKq1hgtdSN4wRXd+w9cWYjwC7lPLcpi6XMUmMsKlZK31vHO+ty7aH/99PnyUsGAwWhVE5ybt3kL41aW71KL6bPi2W7b27aCunz6e0lKJGgyrbh1G+ngq4C0er1ISbsDUNmMLn+rWUa5wyuizYVLszoMnrKefuIKSBiwmTbd5oarQtps+vuFz5gj5ZZ3WZ1OetE3QbDcEsk498UIO5QTMF6uNY9bFCMLIHKYYC5/HWYOFD7doGr1i1bg1WLQxjHH949jT4tf3iuCtVM0CuNOxWnyqDbviB9FmgOXK7HOtUqLmobFF/eQ+eAiZA0o1k3zmb+U7iCeyBxVVEchDJ+ZKqJqDlx46f/3nju38ukdwGmRSSuhsU/TfJhG5C/5tSuJH/2T1Drtgeh+8rSBNGOFQMx2aX+7ssgjEZ1UHIIqjRnbNr1KP07MGLv3756fbzbp1GgGH5PDdtrfLfkgL3BPeYEfVErzNFfMpXLHSlFeMseSZWpLqqs2K+750qQU6T6bgPzP2GihAm682OEU0HZHGbHbJAMdSZ+YWjwdVC7HWTO/7aIP0SN4wBNKFQk4ELg0I+6ZQ81i7tci2Yu2qM83p+tsao5yCgo/FkdqG0WJotmQ/8PsqKHyvpObKfhEHh0tuE9QOsMdISRsLUTIaXbXCBkpUV7IQaD4uaBxWr2b3QX6wTfIo9Pkt4llAqWkpozR/GfRvr7FOh2BFqdtJRUJzOzQHdzEokWRKvLoEZm4ALO6SXwoxNIbZ3kyh0cKLSOQwcyKwUevtqWBKXYPLjuXtIuWcC5U0BoZKHXHF4AYCF1olfSxyudpqyvY2rxDwJE/ugMpoap/haFpn+ZXUOPhP7sh6qflDgwjw0ALuy5fK5y03s+YXS3FwJ/sc+hlnRgJzIKfMRMYtxGK1RQOy2At8OcKR67djpOzDBx1nCDFZoFt2jdJLlTh93TCX7iq3BdP+F7P53l/gr6f/b6f73VvlLzEDqNeHCQ3AmoXO3/tSryTlEepTHT/SKCzmXarBf4CXm01PoI/j9zlA8NP+OX39kI7x3YYSbgPAfD+MS6lkOAAA=";
    private static final Logger log = LogManager.getLogger(FilterableComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox<O> combobox;
    protected FilterableComboBoxConfig<O> config;
    protected JToggleButton displayDecorator;
    protected FilterableComboBoxHandler<O> handler;
    protected JAXXButtonGroup indexes;
    protected FilterableComboBoxModel<O> model;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected JButton reset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private FilterableComboBox<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Decorator decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    @Override
    public Class<O> getBeanType() {
        return config.getBeanType();
    }
    
    @Override
    public void setBeanType(Class<O> beanType) {
        config.setBeanType(beanType);
    }
    
    @Override
    public Object getBean() {
        return model.getBean();
    }
    
    @Override
    public void setBean(Object bean) {
        model.setBean(bean);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    
    public void setShowReset(boolean showReset) {
        config.setShowReset(showReset);
    }
    
    public void setShowDecorator(boolean showDecorator) {
        config.setShowDecorator(showDecorator);
    }
    
    public void setSortable(boolean sortable) {
        config.setSortable(sortable);
    }
    
    public void setEditable(boolean editable) {
        config.setEditable(editable);
    }
    
    public void setProperty(String property) {
        config.setProperty(property);
    }
    
    public void setSelectedToolTipText(String selectedToolTipText) {
        config.setSelectedToolTipText(selectedToolTipText);
    }
    
    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        config.setNotSelectedToolTipText(notSelectedToolTipText);
    }
    
    public void setPopupTitleText(String popupTitleText) {
        config.setPopupTitleText(popupTitleText);
    }
    
    public void setI18nPrefix(String i18nPrefix) {
        config.setI18nPrefix(i18nPrefix);
    }
    
    public void setData(java.util.List<O> data) {
        model.setData(data);
    }
    
    public void setSelectedItem(O selectedItem) {
        model.setSelectedItem(selectedItem);
    }
    
    public void setIndex(int index) {
        model.setIndex(index);
    }
    
    public boolean isEmpty() { return model.isEmpty(); }
    
    public void reset() { handler.reset(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableComboBox() {
        $initialize();
    }

    public FilterableComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public accessor methods -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox<O> getCombobox() {
        return combobox;
    }

    public FilterableComboBoxConfig<O> getConfig() {
        return config;
    }

    public JToggleButton getDisplayDecorator() {
        return displayDecorator;
    }

    public FilterableComboBoxHandler<O> getHandler() {
        return handler;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public FilterableComboBoxModel<O> getModel() {
        return model;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public JButton getReset() {
        return reset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected accessors methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(reset);
    }

    protected void addChildrenToToolbarRight() {
        toolbarRight.add(displayDecorator);
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new JComboBox<O>());
        
        combobox.setName("combobox");
    }

    protected void createConfig() {
        $objectMap.put("config", config = new FilterableComboBoxConfig<O>());
    }

    protected void createDisplayDecorator() {
        $objectMap.put("displayDecorator", displayDecorator = new JToggleButton());
        
        displayDecorator.setName("displayDecorator");
        displayDecorator.setFocusable(false);
        displayDecorator.setFocusPainted(false);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new FilterableComboBoxModel<O>(config));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusable(false);
        reset.setFocusPainted(false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setBorderPainted(false);
        toolbarRight.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        JAXXObject.initialize(
                this,
                this::$initialize_01_createHandler,
                this::$initialize_01_createComponents,
                this::$initialize_02_registerDataBindings,
                this::$initialize_03_finalizeCreateComponents,
                this::$initialize_03_registerActions,
                this::$initialize_04_applyDataBindings,
                this::$initialize_05_setProperties,
                this::$initialize_06_finalizeInitialize);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createConfig();
        createModel();
        createIndexes();
        createSortGroup();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createToolbarLeft();
        createReset();
        createCombobox();
        createToolbarRight();
        createDisplayDecorator();
        // inline creation of $Table0
        setName("$Table0");
    }

    protected FilterableComboBoxHandler $initialize_01_createHandler() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        return handler = new FilterableComboBoxHandler<>();
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortGroup.setSelectedValue(model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_UP_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortUp.setSelected(!model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_DOWN_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortDown.setSelected(model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showReset", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    toolbarLeft.setVisible(config.isShowReset());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showReset", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
                addPropertyChangeListener("enabled", this);
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    reset.setEnabled(config.isEditable() && isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
                removePropertyChangeListener("enabled", this);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    combobox.setSelectedItem(model.getSelectedItem());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    combobox.setEditable(config.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_FOCUSABLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    combobox.setFocusable(isEnabled() && config.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_RIGHT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showDecorator", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    toolbarRight.setVisible(config.isShowDecorator());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showDecorator", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_DECORATOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showDecorator", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    displayDecorator.setEnabled(config.isShowDecorator());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showDecorator", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(toolbarLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(toolbarRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
    }

    protected void $initialize_03_registerActions() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        FilterableComboBoxReset.init(this, reset, new FilterableComboBoxReset<>());
        FilterableComboBoxDisplayDecorator.init(this, displayDecorator, new FilterableComboBoxDisplayDecorator<>());
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 property setters
        popup.setBorder( new TitledBorder(t("bean.sort.title") + "      ") );
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
