/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.widgets.JaxxWidgetRuntimeException;
import org.nuiton.jaxx.widgets.ModelToBean;

public class MutateOnConditionalPropertyChangeListener<M extends ModelToBean>
implements PropertyChangeListener {
    private static final Logger log = LogManager.getLogger(MutateOnConditionalPropertyChangeListener.class);
    private final M model;
    private final Method mutator;
    private final Predicate<M> canMutatePredicate;
    private final String propertyName;

    public MutateOnConditionalPropertyChangeListener(M model, Method mutator, Predicate<M> canMutatePredicate) {
        this.model = (ModelToBean)Objects.requireNonNull(model);
        this.mutator = Objects.requireNonNull(mutator);
        this.canMutatePredicate = Objects.requireNonNull(canMutatePredicate);
        this.propertyName = mutator.getName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.canMutatePredicate.test(this.model)) {
            Object newValue = evt.getNewValue();
            log.debug("Mutates property " + this.propertyName + " with value " + newValue + " on " + this.model);
            try {
                this.mutator.invoke(this.model.getBean(), newValue);
            }
            catch (Exception e) {
                throw new JaxxWidgetRuntimeException("Can't mutate property " + this.propertyName + " on " + this.model, e);
            }
        }
    }
}

